/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.diff.internal;

import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.diff.Chunk;
import org.xwiki.diff.PatchException;

public class DefaultChunk<E>
implements Chunk<E> {
    private final int index;
    private List<E> elements;

    public DefaultChunk(int index, List<E> elements) {
        this.index = index;
        this.elements = elements;
    }

    public DefaultChunk(com.github.difflib.patch.Chunk<E> chunk) {
        this(chunk.getPosition(), chunk.getLines());
    }

    @Override
    public void verify(List<E> target) throws PatchException {
        if (this.getLastIndex() > target.size()) {
            throw new PatchException("Incorrect Chunk: the position of chunk > target size");
        }
        for (int i = 0; i < this.size(); ++i) {
            if (target.get(this.index + i).equals(this.elements.get(i))) continue;
            throw new PatchException("Incorrect Chunk: the chunk content doesn't match the target");
        }
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setElements(List<E> lines) {
        this.elements = lines;
    }

    @Override
    public List<E> getElements() {
        return this.elements;
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public int getLastIndex() {
        return this.getIndex() + this.size() - 1;
    }

    @Override
    public boolean isOverlappingWith(Chunk<E> otherChunk) {
        if (this.getIndex() <= otherChunk.getIndex()) {
            return this.getLastIndex() + 1 >= otherChunk.getIndex();
        }
        return this.getIndex() <= otherChunk.getLastIndex() + 1;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append(this.getElements());
        builder.append(this.getIndex());
        return builder.toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Chunk) {
            Chunk otherChunk = (Chunk)obj;
            return this.getIndex() == otherChunk.getIndex() && Objects.equals(this.getElements(), otherChunk.getElements());
        }
        return false;
    }

    public String toString() {
        return "[position: " + this.index + ", size: " + this.size() + ", lines: " + this.elements + "]";
    }
}

