/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.diff.internal;

import com.github.difflib.patch.AbstractDelta;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.xwiki.diff.Delta;
import org.xwiki.diff.DiffException;
import org.xwiki.diff.Patch;
import org.xwiki.diff.PatchException;
import org.xwiki.diff.internal.DeltaFactory;

public class DefaultPatch<E>
extends LinkedList<Delta<E>>
implements Patch<E> {
    private static final long serialVersionUID = 1L;

    public DefaultPatch() {
    }

    public DefaultPatch(com.github.difflib.patch.Patch<E> patch) throws DiffException {
        for (AbstractDelta delta : patch.getDeltas()) {
            this.add(this.toDelta(delta));
        }
    }

    private Delta<E> toDelta(AbstractDelta<E> delta) throws DiffException {
        try {
            return DeltaFactory.createDelta(delta.getSource(), delta.getTarget(), Delta.Type.valueOf(delta.getType().name()));
        }
        catch (IllegalArgumentException e) {
            throw new DiffException(String.format("Failed to convert [%s] info [%s]. Unknown type [%s]", delta.getClass().getName(), Delta.class.getName(), delta.getType().toString()), e);
        }
    }

    @Override
    public List<E> apply(List<E> target) throws PatchException {
        LinkedList<E> result = new LinkedList<E>(target);
        ListIterator it = this.listIterator(this.size());
        while (it.hasPrevious()) {
            Delta delta = (Delta)it.previous();
            delta.apply(result);
        }
        return result;
    }

    @Override
    public List<E> restore(List<E> target) throws PatchException {
        LinkedList<E> result = new LinkedList<E>(target);
        ListIterator it = this.listIterator(this.size());
        while (it.hasPrevious()) {
            Delta delta = (Delta)it.previous();
            delta.restore(result);
        }
        return result;
    }
}

