/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.params.cipher.asymmetric;

import java.security.SecureRandom;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.xwiki.crypto.params.cipher.asymmetric.AsymmetricCipherParameters;
import org.xwiki.stability.Unstable;

@Unstable
public class AsymmetricKeyWithIVParameters
implements AsymmetricCipherParameters {
    private final AsymmetricKeyParameter keyParam;
    private final byte[] iv;

    public AsymmetricKeyWithIVParameters(AsymmetricKeyParameter key, byte[] iv) {
        this.keyParam = key;
        this.iv = iv;
    }

    public AsymmetricKeyWithIVParameters(AsymmetricKeyParameter key, int ivSize) {
        this(key, ivSize, new SecureRandom());
    }

    public AsymmetricKeyWithIVParameters(AsymmetricKeyParameter key, int ivSize, SecureRandom random) {
        this.keyParam = key;
        this.iv = new byte[ivSize];
        random.nextBytes(this.iv);
    }

    public AsymmetricKeyParameter getKeyParameters() {
        return this.keyParam;
    }

    public byte[] getIV() {
        return this.iv;
    }
}

