/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.crypto.internal.encoder;

import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.xwiki.crypto.internal.encoder.InternalBinaryStringEncoder;

class BcBinaryStringEncoderInputStream
extends FilterInputStream {
    private final int blockSize;
    private final int charSize;
    private byte[] oneByte = new byte[1];
    private byte[] ofBuf;
    private int ofOff;
    private int ofLen;
    private final InternalBinaryStringEncoder encoder;

    public BcBinaryStringEncoderInputStream(InputStream inputStream, InternalBinaryStringEncoder encoder) {
        super(inputStream);
        this.encoder = encoder;
        this.blockSize = encoder.getEncodingBlockSize();
        this.charSize = encoder.getDecodingBlockSize();
        this.ofBuf = new byte[this.blockSize];
    }

    @Override
    public int read() throws IOException {
        if (this.read(this.oneByte, 0, 1) > 0) {
            return this.oneByte[0];
        }
        return -1;
    }

    @Override
    public int read(byte[] out, int offset, int length) throws IOException {
        int blen;
        InputBuffer inBuf;
        int rlen;
        if ((offset | length | out.length - (length + offset) | offset + length) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return 0;
        }
        int readLen = 0;
        int off = offset;
        int len = length;
        if (this.ofLen > 0) {
            int clen = this.copyData(this.ofBuf, this.ofOff, this.ofLen, out, off, len);
            this.ofLen -= clen;
            this.ofOff += clen;
            off += clen;
            len -= clen;
            readLen += clen;
        }
        if (len > 0 && (rlen = (inBuf = new InputBuffer(blen = (len + this.blockSize - 1) / this.blockSize)).getEffectiveLength()) > 0) {
            int rblen = (rlen + this.charSize - 1) / this.charSize;
            ByteArrayOutputStream baos = new ByteArrayOutputStream(rblen * this.blockSize);
            this.encoder.decode(inBuf.getBuffer(), 0, inBuf.getReadLength(), baos);
            baos.close();
            int clen = this.copyData(baos.toByteArray(), 0, baos.size(), out, off, len);
            readLen += clen;
            this.ofLen = baos.size() - clen;
            this.ofOff = 0;
            if (this.ofLen > 0) {
                System.arraycopy(baos.toByteArray(), clen, this.ofBuf, this.ofOff, this.ofLen);
            }
        }
        return readLen > 0 ? readLen : -1;
    }

    @Override
    public int available() throws IOException {
        int len = super.available();
        return (len + this.charSize - 1) / this.charSize * this.blockSize;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    private int copyData(byte[] inBuf, int inOff, int inLen, byte[] outBuf, int outOff, int outLen) {
        int clen = inLen;
        if (clen > outLen) {
            clen = outLen;
        }
        System.arraycopy(inBuf, inOff, outBuf, outOff, clen);
        return clen;
    }

    class InputBuffer {
        private byte[] buf;
        private int bufLen;
        private int bcount;
        private int rblank;

        InputBuffer(int blen) throws IOException {
            int rlen = 0;
            int rbl = blen * BcBinaryStringEncoderInputStream.this.charSize;
            this.buf = new byte[rbl];
            while (rbl > 0 && rlen >= 0) {
                rlen = this.read(rbl);
                rbl = this.rblank;
            }
            rlen = this.bufLen - this.bcount;
            if (rlen > 0) {
                int rblen = (rlen + BcBinaryStringEncoderInputStream.this.charSize - 1) / BcBinaryStringEncoderInputStream.this.charSize;
                int runder = rblen * BcBinaryStringEncoderInputStream.this.charSize - rlen;
                int rrlen = 0;
                while (runder > 0 && rrlen >= 0) {
                    rrlen = this.read(runder);
                    if (rrlen <= 0) continue;
                    runder -= rrlen - this.rblank;
                }
            }
        }

        byte[] getBuffer() {
            return this.buf;
        }

        int getReadLength() {
            return this.bufLen;
        }

        int getEffectiveLength() {
            return this.bufLen - this.bcount;
        }

        private int countBlank(int off, int len) {
            int blank = 0;
            for (int i = off; i < len; ++i) {
                if (!this.isBlank(this.buf[i])) continue;
                ++blank;
            }
            return blank;
        }

        private boolean isBlank(byte b) {
            return b == 10 || b == 13 || b == 9 || b == 32;
        }

        private void ensureSize(int len) {
            if (len > this.buf.length) {
                byte[] nbuf = new byte[len];
                System.arraycopy(this.buf, 0, nbuf, 0, this.buf.length);
                this.buf = nbuf;
            }
        }

        private int read(int len) throws IOException {
            this.ensureSize(this.bufLen + len);
            return this.readBase64(len);
        }

        private int readBase64(int len) throws IOException {
            int rlen = BcBinaryStringEncoderInputStream.this.in.markSupported() ? this.readBase64WithMark(len) : this.readBase64WithoutMark(len);
            if (rlen > 0) {
                this.rblank = this.countBlank(this.bufLen, rlen);
                this.bufLen += rlen;
                this.bcount += this.rblank;
                return rlen;
            }
            return -1;
        }

        private int readBase64WithoutMark(int len) throws IOException {
            byte b;
            int c;
            int rlen = this.bufLen;
            while (rlen < this.bufLen + len && (c = BcBinaryStringEncoderInputStream.this.in.read()) >= 0 && (this.isBlank(b = (byte)c) || BcBinaryStringEncoderInputStream.this.encoder.isValidEncoding(b))) {
                this.buf[rlen++] = b;
            }
            return rlen -= this.bufLen;
        }

        private int readBase64WithMark(int len) throws IOException {
            byte b;
            int i;
            BcBinaryStringEncoderInputStream.this.in.mark(len);
            int rlen = BcBinaryStringEncoderInputStream.this.in.read(this.buf, this.bufLen, len);
            for (i = this.bufLen; i < this.bufLen + rlen && (this.isBlank(b = this.buf[i]) || BcBinaryStringEncoderInputStream.this.encoder.isValidEncoding(b)); ++i) {
            }
            if ((i -= this.bufLen) < rlen) {
                BcBinaryStringEncoderInputStream.this.in.reset();
                rlen = (int)BcBinaryStringEncoderInputStream.this.in.skip(i);
            }
            return rlen;
        }
    }
}

