/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.context.internal.concurrent;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.context.concurrent.ContextStore;
import org.xwiki.context.concurrent.ContextStoreManager;

@Component
@Singleton
public class DefaultContextStoreManager
implements ContextStoreManager {
    @Inject
    private ComponentManager componentManager;

    @Override
    public Collection<String> getSupportedEntries() throws ComponentLookupException {
        TreeSet<String> entries = new TreeSet<String>();
        List stores = this.componentManager.getInstanceList(ContextStore.class);
        for (ContextStore store : stores) {
            entries.addAll(store.getSupportedEntries());
        }
        return entries;
    }

    @Override
    public Map<String, Serializable> save(Collection<String> entries) throws ComponentLookupException {
        Map<String, Serializable> context;
        if (entries == null) {
            return null;
        }
        if (!entries.isEmpty()) {
            context = new HashMap();
            List stores = this.componentManager.getInstanceList(ContextStore.class);
            for (ContextStore store : stores) {
                store.save(context, entries);
            }
        } else {
            context = Collections.emptyMap();
        }
        return context;
    }

    @Override
    public void restore(Map<String, Serializable> contextStore) throws ComponentLookupException {
        if (contextStore != null && !contextStore.isEmpty()) {
            List stores = this.componentManager.getInstanceList(ContextStore.class);
            for (ContextStore store : stores) {
                store.restore(contextStore);
            }
        }
    }
}

