/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.configuration.internal;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSaveException;
import org.xwiki.configuration.internal.AbstractPropertiesConfigurationSource;

@Component
@Singleton
@Named(value="systemproperties")
public class SystemPropertiesConfigurationSource
extends AbstractPropertiesConfigurationSource {
    public static final String HINT = "systemproperties";
    public static final String PREFIX = "xconf.";

    String getSystemProperty(String key) {
        return System.getProperty(key);
    }

    Properties getSystemProperties() {
        return System.getProperties();
    }

    String setSystemProperty(String key, String value) {
        return System.setProperty(key, value);
    }

    void setSystemProperties(Properties properties) {
        System.setProperties(properties);
    }

    @Override
    public <T> T getPropertyInternal(String key) {
        if (key == null) {
            return null;
        }
        return (T)this.getSystemProperty(this.toSystemKey(key));
    }

    @Override
    public List<String> getKeysInternal() {
        return this.getKeys("");
    }

    @Override
    public List<String> getKeysInternal(String prefix) {
        String systemPrefix = this.toSystemKey(prefix);
        return this.getSystemProperties().keySet().stream().filter(k -> this.isSystemKey(k, systemPrefix)).map(this::fromSystemKey).toList();
    }

    @Override
    public boolean containsKeyInternal(String key) {
        if (key == null) {
            return false;
        }
        return this.getSystemProperties().containsKey(this.toSystemKey(key));
    }

    @Override
    public boolean isEmptyInternal() {
        return this.isEmpty("");
    }

    @Override
    public boolean isEmptyInternal(String prefix) {
        Properties properties = this.getSystemProperties();
        if (properties.isEmpty()) {
            return properties.isEmpty();
        }
        String systemPrefix = this.toSystemKey(prefix);
        return properties.keySet().stream().noneMatch(k -> this.isSystemKey(k, systemPrefix));
    }

    public void setProperty(String key, Object value) throws ConfigurationSaveException {
        this.setSystemProperty(this.toSystemKey(key), (String)this.converterManager.convert(String.class, value));
    }

    public void setProperties(Map<String, Object> properties) throws ConfigurationSaveException {
        Properties systemProperties = new Properties();
        this.getSystemProperties().entrySet().stream().filter(e -> !this.isSystemKey(e.getKey(), PREFIX)).forEach(e -> systemProperties.put(e.getKey(), e.getValue()));
        properties.forEach((key, value) -> systemProperties.setProperty(this.toSystemKey(key), (String)this.converterManager.convert(String.class, value)));
        this.setSystemProperties(systemProperties);
    }

    private boolean isSystemKey(Object key, String systemPrefix) {
        String keyString;
        return key instanceof String && (keyString = (String)key).startsWith(systemPrefix);
    }

    private String toSystemKey(Object key) {
        return PREFIX + String.valueOf(key);
    }

    private String fromSystemKey(Object key) {
        return key.toString().substring(PREFIX.length());
    }
}

