/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.configuration.internal;

import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.internal.AbstractPropertiesConfigurationSource;

@Component
@Singleton
@Named(value="systemenv")
public class SystemEnvConfigurationSource
extends AbstractPropertiesConfigurationSource {
    public static final String HINT = "systemenv";
    public static final String PREFIX = "XCONF_";

    Map<String, String> getenv() {
        return System.getenv();
    }

    String getenv(String name) {
        return System.getenv(name);
    }

    @Override
    public <T> T getPropertyInternal(String key) {
        if (key == null) {
            return null;
        }
        return (T)this.getenv(this.toEnvKey(key));
    }

    @Override
    public List<String> getKeysInternal() {
        return this.getKeys("");
    }

    @Override
    public List<String> getKeysInternal(String prefix) {
        String encodedPrefix = this.encode(prefix);
        String encodedCompletePrefix = PREFIX + encodedPrefix;
        return this.getenv().keySet().stream().filter(k -> this.isEnvKey((String)k, encodedCompletePrefix)).map(k -> this.fromEnvKey((String)k, prefix, encodedPrefix)).toList();
    }

    @Override
    public boolean containsKeyInternal(String key) {
        if (key == null) {
            return false;
        }
        return this.getenv().containsKey(this.toEnvKey(key));
    }

    @Override
    public boolean isEmptyInternal() {
        return this.isEmpty("");
    }

    @Override
    public boolean isEmptyInternal(String prefix) {
        Map<String, String> env = this.getenv();
        if (env.isEmpty()) {
            return true;
        }
        String encodedCompletePrefix = this.toEnvKey(prefix);
        return env.keySet().stream().noneMatch(k -> this.isEnvKey((String)k, encodedCompletePrefix));
    }

    private String encode(String property) {
        if (property.isEmpty()) {
            return property;
        }
        StringBuilder builder = new StringBuilder(property.length() * 3);
        this.encode(property, builder);
        return builder.toString();
    }

    private void encode(String property, StringBuilder builder) {
        for (int i = 0; i < property.length(); ++i) {
            char c = property.charAt(i);
            boolean encode = false;
            if (i == 0) {
                if (Character.isDigit(c)) {
                    encode = true;
                }
            } else if (c != '_' && !Character.isAlphabetic(c) && !Character.isDigit(c)) {
                encode = true;
            }
            if (encode) {
                this.encode(c, builder);
                continue;
            }
            builder.append(c);
        }
    }

    private String toEnvKey(String property) {
        if (property.isEmpty()) {
            return PREFIX;
        }
        StringBuilder builder = new StringBuilder(property.length() * 3);
        builder.append(PREFIX);
        this.encode(property, builder);
        return builder.toString();
    }

    private void encode(char c, StringBuilder builder) {
        builder.append('_');
        switch (c) {
            case '-': 
            case '.': 
            case ':': {
                break;
            }
            default: {
                byte[] ba = String.valueOf(c).getBytes(StandardCharsets.UTF_8);
                for (int j = 0; j < ba.length; ++j) {
                    this.urlEncode(c, builder);
                }
            }
        }
    }

    private void urlEncode(char c, StringBuilder builder) {
        byte[] ba = String.valueOf(c).getBytes(StandardCharsets.UTF_8);
        for (int j = 0; j < ba.length; ++j) {
            char ch = Character.forDigit(ba[j] >> 4 & 0xF, 16);
            ch = Character.toUpperCase(ch);
            builder.append(ch);
            ch = Character.forDigit(ba[j] & 0xF, 16);
            ch = Character.toUpperCase(ch);
            builder.append(ch);
        }
    }

    private boolean isEnvKey(String key, String encodedCompletePrefix) {
        return key.startsWith(encodedCompletePrefix);
    }

    private String fromEnvKey(String key, String prefix, String encodedPrefix) {
        String property = key.substring(PREFIX.length() + encodedPrefix.length());
        property = property.replace('_', '.');
        return prefix + property;
    }
}

