/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.configuration.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.internal.AbstractConfigurationSource;

@Component
@Singleton
@Named(value="memory")
public class MemoryConfigurationSource
extends AbstractConfigurationSource {
    private Map<String, Object> properties = new ConcurrentHashMap<String, Object>();

    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public void removeProperty(String key) {
        this.properties.remove(key);
    }

    @Override
    public <T> T getProperty(String key, T defaultValue) {
        Object value = this.properties.containsKey(key) ? this.properties.get(key) : defaultValue;
        return value;
    }

    @Override
    public <T> T getProperty(String key, Class<T> valueClass) {
        T value = this.properties.containsKey(key) ? valueClass.cast(this.properties.get(key)) : this.getDefault(valueClass);
        return value;
    }

    @Override
    public <T> T getProperty(String key) {
        return (T)this.properties.get(key);
    }

    @Override
    public List<String> getKeys() {
        return new ArrayList<String>(this.properties.keySet());
    }

    @Override
    public boolean containsKey(String key) {
        return this.properties.containsKey(key);
    }

    @Override
    public boolean isEmpty() {
        return this.properties.isEmpty();
    }
}

