/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.configuration.internal;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.configuration.internal.AbstractConfigurationSource;

public abstract class AbstractCompositeConfigurationSource
extends AbstractConfigurationSource
implements Iterable<ConfigurationSource> {
    @Override
    public boolean containsKey(String key) {
        boolean result = false;
        for (ConfigurationSource source : this) {
            if (!source.containsKey(key)) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public <T> T getProperty(String key) {
        T result = null;
        for (ConfigurationSource source : this) {
            if (!source.containsKey(key)) continue;
            result = source.getProperty(key);
            break;
        }
        return result;
    }

    @Override
    public <T> T getProperty(String key, Class<T> valueClass) {
        T result = null;
        for (ConfigurationSource source : this) {
            if (!source.containsKey(key)) continue;
            result = source.getProperty(key, valueClass);
            break;
        }
        if (result == null) {
            result = this.getDefault(valueClass);
        }
        return result;
    }

    @Override
    public <T> T getProperty(String key, T defaultValue) {
        T result = null;
        for (ConfigurationSource source : this) {
            if (!source.containsKey(key)) continue;
            result = source.getProperty(key, defaultValue);
            break;
        }
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    @Override
    public List<String> getKeys() {
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        for (ConfigurationSource source : this) {
            keys.addAll(source.getKeys());
        }
        return new ArrayList<String>(keys);
    }

    @Override
    public List<String> getKeys(String prefix) {
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        for (ConfigurationSource source : this) {
            keys.addAll(source.getKeys(prefix));
        }
        return new ArrayList<String>(keys);
    }

    @Override
    public boolean isEmpty() {
        for (ConfigurationSource source : this) {
            if (source.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty(String prefix) {
        for (ConfigurationSource source : this) {
            if (source.isEmpty(prefix)) continue;
            return false;
        }
        return true;
    }
}

