/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.embed;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import javax.inject.Provider;
import org.xwiki.component.annotation.ComponentRole;
import org.xwiki.component.annotation.Role;
import org.xwiki.component.internal.RoleHint;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.util.ReflectionUtils;

public class GenericProvider<T>
implements Provider<T> {
    private ComponentManager componentManager;
    private RoleHint<T> roleHint;

    public GenericProvider(ComponentManager componentManager, RoleHint<T> roleHint) {
        this.componentManager = componentManager;
        this.roleHint = roleHint;
    }

    public T get() {
        Object component;
        try {
            Class<T> roleClass = this.roleHint.getRoleClass();
            if (roleClass.isAssignableFrom(Provider.class)) {
                try {
                    component = this.componentManager.lookupComponent(this.roleHint.getRoleType(), this.roleHint.getHint());
                }
                catch (ComponentLookupException e) {
                    component = new GenericProvider(this.componentManager, new RoleHint(ReflectionUtils.getLastTypeGenericArgument((Type)this.roleHint.getRoleType()), this.roleHint.getHint()));
                }
            } else {
                component = roleClass.isAssignableFrom(List.class) ? this.componentManager.lookupList(ReflectionUtils.getLastTypeGenericArgument((Type)this.roleHint.getRoleType())) : (roleClass.isAssignableFrom(Map.class) ? this.componentManager.lookupMap(ReflectionUtils.getLastTypeGenericArgument((Type)this.roleHint.getRoleType())) : (ReflectionUtils.getDirectAnnotation(ComponentRole.class, roleClass) != null && ReflectionUtils.getDirectAnnotation(Role.class, roleClass) == null ? this.componentManager.lookupComponent(roleClass, this.roleHint.getHint()) : this.componentManager.lookupComponent(this.roleHint.getRoleType(), this.roleHint.getHint())));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get [" + this.roleHint + "]", e);
        }
        return (T)component;
    }
}

