/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.embed;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.component.annotation.ComponentAnnotationLoader;
import org.xwiki.component.descriptor.ComponentDependency;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.embed.GenericProvider;
import org.xwiki.component.embed.LifecycleHandler;
import org.xwiki.component.internal.RoleHint;
import org.xwiki.component.manager.ComponentEventManager;
import org.xwiki.component.manager.ComponentLifecycleException;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.manager.ComponentManagerInitializer;
import org.xwiki.component.manager.ComponentRepositoryException;
import org.xwiki.component.phase.Disposable;
import org.xwiki.component.util.ReflectionUtils;

public class EmbeddableComponentManager
implements ComponentManager {
    private ComponentEventManager eventManager;
    private ComponentManager parent;
    private Map<RoleHint<?>, ComponentDescriptor<?>> descriptors = new HashMap();
    private Map<RoleHint<?>, Object> components = new ConcurrentHashMap();
    private Map<RoleHint<?>, Provider<?>> providers = new ConcurrentHashMap();
    private Logger logger = LoggerFactory.getLogger(EmbeddableComponentManager.class);
    private ServiceLoader<LifecycleHandler> lifecycleHandlers = ServiceLoader.load(LifecycleHandler.class);

    public void initialize(ClassLoader classLoader) {
        ComponentAnnotationLoader loader = new ComponentAnnotationLoader();
        loader.initialize(this, classLoader);
        try {
            List<ComponentManagerInitializer> initializers = this.lookupList(ComponentManagerInitializer.class);
            for (ComponentManagerInitializer initializer : initializers) {
                initializer.initialize((ComponentManager)this);
            }
        }
        catch (ComponentLookupException e) {
            this.logger.error("Failed to lookup ComponentManagerInitializer components", (Throwable)e);
        }
    }

    public <T> boolean hasComponent(Class<T> role, String hint) {
        return this.descriptors.containsKey(new RoleHint<T>(role, hint));
    }

    public <T> boolean hasComponent(Class<T> role) {
        return this.descriptors.containsKey(new RoleHint<T>(role));
    }

    public <T> T lookup(Class<T> role) throws ComponentLookupException {
        return this.initialize(new RoleHint<T>(role));
    }

    public <T> T lookup(Class<T> role, String hint) throws ComponentLookupException {
        return this.initialize(new RoleHint<T>(role, hint));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> lookupList(Class<T> role) throws ComponentLookupException {
        ArrayList objects = new ArrayList();
        EmbeddableComponentManager embeddableComponentManager = this;
        synchronized (embeddableComponentManager) {
            for (RoleHint<?> roleHint : this.descriptors.keySet()) {
                if (!roleHint.getRole().getName().equals(role.getName())) continue;
                objects.add(this.initialize(roleHint));
            }
            if (this.getParent() != null) {
                objects.addAll(this.getParent().lookupList(role));
            }
        }
        return objects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Map<String, T> lookupMap(Class<T> role) throws ComponentLookupException {
        HashMap<String, Object> objects = new HashMap<String, Object>();
        EmbeddableComponentManager embeddableComponentManager = this;
        synchronized (embeddableComponentManager) {
            for (RoleHint<?> roleHint : this.descriptors.keySet()) {
                if (!roleHint.getRole().getName().equals(role.getName())) continue;
                objects.put(roleHint.getHint(), this.initialize(roleHint));
            }
            if (this.getParent() != null) {
                for (Map.Entry entry : this.getParent().lookupMap(role).entrySet()) {
                    if (objects.containsKey(entry.getKey())) continue;
                    objects.put((String)entry.getKey(), entry.getValue());
                }
            }
        }
        return objects;
    }

    public <T> void registerComponent(ComponentDescriptor<T> componentDescriptor) throws ComponentRepositoryException {
        this.registerComponent(componentDescriptor, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void registerComponent(ComponentDescriptor<T> componentDescriptor, T componentInstance) {
        EmbeddableComponentManager embeddableComponentManager = this;
        synchronized (embeddableComponentManager) {
            RoleHint roleHint = new RoleHint(componentDescriptor.getRole(), componentDescriptor.getRoleHint());
            this.removeComponentWithoutException(roleHint, true);
            this.addComponent(roleHint, componentInstance, componentDescriptor, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void unregisterComponent(Class<T> role, String hint) {
        EmbeddableComponentManager embeddableComponentManager = this;
        synchronized (embeddableComponentManager) {
            RoleHint<T> roleHint = new RoleHint<T>(role, hint);
            this.removeComponentWithoutException(roleHint, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> ComponentDescriptor<T> getComponentDescriptor(Class<T> role, String hint) {
        EmbeddableComponentManager embeddableComponentManager = this;
        synchronized (embeddableComponentManager) {
            return this.descriptors.get(new RoleHint<T>(role, hint));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<ComponentDescriptor<T>> getComponentDescriptorList(Class<T> role) {
        EmbeddableComponentManager embeddableComponentManager = this;
        synchronized (embeddableComponentManager) {
            ArrayList<ComponentDescriptor<T>> results = new ArrayList<ComponentDescriptor<T>>();
            for (Map.Entry<RoleHint<?>, ComponentDescriptor<?>> entry : this.descriptors.entrySet()) {
                if (!entry.getKey().getRole().getName().equals(role.getName())) continue;
                results.add(entry.getValue());
            }
            return results;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void release(T component) throws ComponentLifecycleException {
        EmbeddableComponentManager embeddableComponentManager = this;
        synchronized (embeddableComponentManager) {
            RoleHint<?> key = null;
            for (Map.Entry<RoleHint<?>, Object> entry : this.components.entrySet()) {
                if (entry.getValue() != component) continue;
                key = entry.getKey();
                break;
            }
            if (key != null) {
                ComponentDescriptor<?> oldDescriptor = this.descriptors.get(key);
                this.removeComponent(key, oldDescriptor, true);
                this.addComponent(key, null, oldDescriptor, true);
            }
        }
    }

    public ComponentEventManager getComponentEventManager() {
        return this.eventManager;
    }

    public void setComponentEventManager(ComponentEventManager eventManager) {
        this.eventManager = eventManager;
    }

    public ComponentManager getParent() {
        return this.parent;
    }

    public void setParent(ComponentManager parentComponentManager) {
        this.parent = parentComponentManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> T initialize(RoleHint<T> roleHint) throws ComponentLookupException {
        Object instance = this.components.get(roleHint);
        if (instance != null) return (T)instance;
        EmbeddableComponentManager embeddableComponentManager = this;
        synchronized (embeddableComponentManager) {
            instance = this.components.get(roleHint);
            if (instance != null) return (T)instance;
            ComponentDescriptor<?> descriptor = this.descriptors.get(roleHint);
            if (descriptor != null) {
                try {
                    instance = this.createInstance(descriptor);
                    if (instance == null) {
                        throw new ComponentLookupException("Failed to lookup component [" + roleHint + "]");
                    }
                    if (this.descriptors.get(roleHint).getInstantiationStrategy() != ComponentInstantiationStrategy.SINGLETON) return (T)instance;
                    this.addComponent(roleHint, instance, descriptor, false);
                }
                catch (Exception e) {
                    throw new ComponentLookupException("Failed to lookup component [" + roleHint + "]", (Throwable)e);
                }
            } else {
                ComponentManager parent = this.getParent();
                if (parent == null) throw new ComponentLookupException("Can't find descriptor for the component [" + roleHint + "]");
                instance = this.getParent().lookup(roleHint.getRole(), roleHint.getHint());
            }
            return (T)instance;
        }
    }

    private <T> T createInstance(ComponentDescriptor<T> descriptor) throws Exception {
        Object instance = descriptor.getImplementation().newInstance();
        for (ComponentDependency dependency : descriptor.getComponentDependencies()) {
            Field field;
            Class fieldRole;
            RoleHint roleHint;
            GenericProvider provider;
            Object fieldValue = Provider.class.isAssignableFrom(dependency.getMappingType()) ? ((provider = this.providers.get(roleHint = new RoleHint(fieldRole = ReflectionUtils.getLastGenericFieldType((Field)(field = instance.getClass().getDeclaredField(dependency.getName()))), dependency.getRoleHint()))) != null ? provider : new GenericProvider(this, new RoleHint(fieldRole))) : (dependency.getMappingType() != null && Logger.class.isAssignableFrom(dependency.getMappingType()) ? LoggerFactory.getLogger(instance.getClass()) : (dependency.getMappingType() != null && List.class.isAssignableFrom(dependency.getMappingType()) ? this.lookupList(dependency.getRole()) : (dependency.getMappingType() != null && Map.class.isAssignableFrom(dependency.getMappingType()) ? this.lookupMap(dependency.getRole()) : this.lookup(dependency.getRole(), dependency.getRoleHint()))));
            if (fieldValue == null) continue;
            ReflectionUtils.setFieldValue(instance, (String)dependency.getName(), (Object)fieldValue);
        }
        for (LifecycleHandler lifecycleHandler : this.lifecycleHandlers) {
            lifecycleHandler.handle(instance, descriptor, this);
        }
        return instance;
    }

    private <T> void addComponent(RoleHint<T> roleHint, T instance, ComponentDescriptor<T> descriptor, boolean addDescriptor) {
        if (instance != null) {
            this.components.put(roleHint, instance);
            if (Provider.class.isAssignableFrom(instance.getClass())) {
                Provider provider = (Provider)instance;
                Class roleClass = ReflectionUtils.getLastGenericClassType(instance.getClass(), Provider.class);
                this.providers.put(new RoleHint(roleClass, descriptor.getRoleHint()), provider);
            }
        }
        if (addDescriptor) {
            if (this.eventManager != null) {
                this.eventManager.notifyComponentRegistered(descriptor);
            }
            this.descriptors.put(roleHint, descriptor);
        }
    }

    private <T> T removeComponent(RoleHint<T> roleHint, boolean removeDescriptor) throws ComponentLifecycleException {
        return this.removeComponent(roleHint, this.descriptors.get(roleHint), removeDescriptor);
    }

    private <T> T removeComponent(RoleHint<T> roleHint, ComponentDescriptor<T> descriptor, boolean removeDescriptor) throws ComponentLifecycleException {
        Object component = this.components.remove(roleHint);
        if (component instanceof Disposable) {
            ((Disposable)component).dispose();
        }
        if (component != null && Provider.class.isAssignableFrom(component.getClass())) {
            Class roleClass = ReflectionUtils.getLastGenericClassType(component.getClass(), Provider.class);
            this.providers.remove(new RoleHint(roleClass, descriptor.getRoleHint()));
        }
        if (removeDescriptor) {
            ComponentDescriptor<?> oldDescriptor = this.descriptors.remove(roleHint);
            if (this.eventManager != null && oldDescriptor != null) {
                this.eventManager.notifyComponentUnregistered(oldDescriptor);
            }
        }
        return (T)component;
    }

    private <T> void removeComponentWithoutException(RoleHint<T> roleHint, boolean removeDescriptor) {
        try {
            this.removeComponent(roleHint, removeDescriptor);
        }
        catch (Exception e) {
            this.logger.warn("Instance released but disposal failed. Some resources may not have been released.", (Throwable)e);
        }
    }
}

