/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.internal.multi;

import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.internal.multi.ComponentManagerFactory;
import org.xwiki.component.internal.multi.ComponentManagerManager;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;

@Component
@Singleton
public class DefaultComponentManagerManager
implements ComponentManagerManager {
    @Inject
    private ComponentManagerFactory defaultComponentManagerFactory;
    @Inject
    private ComponentManager rootComponentManager;
    private Map<String, ComponentManager> componentManagers = new ConcurrentHashMap<String, ComponentManager>();

    @Override
    public ComponentManager getComponentManager(String path, boolean create) {
        ComponentManager componentManager;
        if (path == null) {
            componentManager = this.rootComponentManager;
        } else {
            componentManager = this.componentManagers.get(path);
            if (componentManager == null && create) {
                componentManager = this.createComponentManager(path);
                this.componentManagers.put(path, componentManager);
            }
        }
        return componentManager;
    }

    private ComponentManager createComponentManager(String id) {
        ComponentManagerFactory componentManagerFactory;
        String prefix = this.getPrefix(id);
        try {
            componentManagerFactory = (ComponentManagerFactory)this.rootComponentManager.getInstance((Type)((Object)ComponentManagerFactory.class), prefix);
        }
        catch (ComponentLookupException e) {
            componentManagerFactory = this.defaultComponentManagerFactory;
        }
        return componentManagerFactory.createComponentManager(id, this.rootComponentManager);
    }

    private String getPrefix(String id) {
        boolean escaped = false;
        StringBuilder typeBuilder = null;
        for (int i = 0; i < id.length(); ++i) {
            char c = id.charAt(i);
            if (escaped) {
                typeBuilder.append(c);
                continue;
            }
            if (c == '\\') {
                if (typeBuilder != null) continue;
                typeBuilder = new StringBuilder();
                typeBuilder.append(id.substring(0, i));
                continue;
            }
            if (c == ':') {
                return id.substring(0, i);
            }
            if (typeBuilder == null) continue;
            typeBuilder.append(c);
        }
        return null;
    }
}

