/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.internal.multi;

import javax.inject.Inject;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.internal.multi.ComponentManagerManager;
import org.xwiki.component.internal.multi.DelegateComponentManager;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.manager.ComponentRepositoryException;

public abstract class AbstractGenericComponentManager
extends DelegateComponentManager {
    @Inject
    private ComponentManagerManager componentManagerManager;
    private ComponentManager internalParent;

    protected abstract String getKey();

    @Override
    public ComponentManager getComponentManager() {
        ComponentManager componentManager = this.componentManagerManager.getComponentManager(this.getKey(), false);
        if (componentManager == null && (componentManager = this.getInternalParent()) == null) {
            throw new RuntimeException("Key-based Proxy Component Managers should always have a Parent Component Manager defined so that it can be used if there's no Component Manager for the given key");
        }
        return componentManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void registerComponent(ComponentDescriptor<T> componentDescriptor, T componentInstance) throws ComponentRepositoryException {
        AbstractGenericComponentManager abstractGenericComponentManager = this;
        synchronized (abstractGenericComponentManager) {
            this.componentManagerManager.getComponentManager(this.getKey(), true);
            if (componentInstance == null) {
                super.registerComponent(componentDescriptor);
            } else {
                super.registerComponent(componentDescriptor, componentInstance);
            }
        }
    }

    @Override
    public <T> void registerComponent(ComponentDescriptor<T> componentDescriptor) throws ComponentRepositoryException {
        this.registerComponent(componentDescriptor, null);
    }

    @Override
    public <T> void unregisterComponent(Class<T> role, String roleHint) {
        super.unregisterComponent(role, roleHint);
    }

    protected ComponentManager getInternalParent() {
        return this.internalParent;
    }

    protected void setInternalParent(ComponentManager parentComponentManager) {
        this.internalParent = parentComponentManager;
    }
}

