/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.cache.tests;

import org.junit.Assert;
import org.junit.Test;
import org.xwiki.cache.Cache;
import org.xwiki.cache.CacheFactory;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.cache.config.LRUCacheConfiguration;
import org.xwiki.cache.event.CacheEntryListener;
import org.xwiki.cache.eviction.EntryEvictionConfiguration;
import org.xwiki.cache.eviction.LRUEvictionConfiguration;
import org.xwiki.cache.tests.AbstractGenericTestCache;
import org.xwiki.cache.tests.CacheEntryListenerTest;

public abstract class AbstractEvictionGenericTestCache
extends AbstractGenericTestCache {
    private boolean supportEvictionEvent;

    protected AbstractEvictionGenericTestCache(String roleHint, boolean supportEvictionEvent) {
        super(roleHint);
        this.supportEvictionEvent = supportEvictionEvent;
    }

    protected void customizeEviction(EntryEvictionConfiguration eviction) {
    }

    @Test
    public void testCreateAndDestroyCacheLRUMaxEntries() throws Exception {
        CacheEntryListenerTest eventListener;
        CacheFactory factory = this.getCacheFactory();
        CacheConfiguration conf = new CacheConfiguration();
        LRUEvictionConfiguration lec = new LRUEvictionConfiguration();
        lec.setMaxEntries(1);
        this.customizeEviction((EntryEvictionConfiguration)lec);
        conf.put((Object)"eviction", (Object)lec);
        Cache cache = factory.newCache(conf);
        Assert.assertNotNull((Object)cache);
        if (this.supportEvictionEvent) {
            eventListener = new CacheEntryListenerTest();
            cache.addCacheEntryListener((CacheEntryListener)eventListener);
        } else {
            eventListener = null;
        }
        cache.set("key", (Object)"value");
        Assert.assertEquals((Object)"value", (Object)cache.get("key"));
        cache.set("key2", (Object)2);
        if (eventListener != null) {
            Assert.assertTrue((String)"No value has been evicted from the cache", (boolean)eventListener.waitForEntryEvent(CacheEntryListenerTest.EventType.REMOVE));
            Assert.assertSame((Object)"value", (Object)eventListener.getRemovedEvent().getEntry().getValue());
        }
        Assert.assertNull((Object)cache.get("key"));
        Assert.assertEquals((Object)2, (Object)cache.get("key2"));
        cache.dispose();
    }

    @Test
    public void testCreateAndDestroyCacheLRUMAxIdle() throws Exception {
        CacheEntryListenerTest eventListener;
        CacheFactory factory = this.getCacheFactory();
        CacheConfiguration conf = new CacheConfiguration();
        LRUEvictionConfiguration lec = new LRUEvictionConfiguration();
        lec.setMaxIdle(1);
        this.customizeEviction((EntryEvictionConfiguration)lec);
        conf.put((Object)"eviction", (Object)lec);
        Cache cache = factory.newCache(conf);
        Assert.assertNotNull((Object)cache);
        if (this.supportEvictionEvent) {
            eventListener = new CacheEntryListenerTest();
            cache.addCacheEntryListener((CacheEntryListener)eventListener);
        } else {
            eventListener = null;
        }
        cache.set("key", (Object)"value");
        Assert.assertEquals((Object)"value", (Object)cache.get("key"));
        if (eventListener != null) {
            Assert.assertTrue((String)"No value has expired from the cache after provided max idle time", (boolean)eventListener.waitForEntryEvent(CacheEntryListenerTest.EventType.REMOVE));
            Assert.assertSame((Object)"value", (Object)eventListener.getRemovedEvent().getEntry().getValue());
        }
        Assert.assertNull((Object)cache.get("key"));
        cache.dispose();
    }

    @Test
    public void testCreateAndDestroyCacheLRULifespan() throws Exception {
        CacheEntryListenerTest eventListener;
        CacheFactory factory = this.getCacheFactory();
        CacheConfiguration conf = new CacheConfiguration();
        LRUEvictionConfiguration lec = new LRUEvictionConfiguration();
        lec.setLifespan(1);
        this.customizeEviction((EntryEvictionConfiguration)lec);
        conf.put((Object)"eviction", (Object)lec);
        Cache cache = factory.newCache(conf);
        Assert.assertNotNull((Object)cache);
        if (this.supportEvictionEvent) {
            eventListener = new CacheEntryListenerTest();
            cache.addCacheEntryListener((CacheEntryListener)eventListener);
        } else {
            eventListener = null;
        }
        cache.set("key", (Object)"value");
        Assert.assertEquals((Object)"value", (Object)cache.get("key"));
        if (eventListener != null) {
            Assert.assertTrue((String)"No value has expired from the cache after provide lifespan", (boolean)eventListener.waitForEntryEvent(CacheEntryListenerTest.EventType.REMOVE));
            Assert.assertSame((Object)"value", (Object)eventListener.getRemovedEvent().getEntry().getValue());
        }
        Assert.assertNull((Object)cache.get("key"));
        cache.dispose();
    }

    @Test
    public void testCreateAndDestroyCacheLRUAll() throws Exception {
        CacheFactory factory = this.getCacheFactory();
        LRUCacheConfiguration conf = new LRUCacheConfiguration();
        LRUEvictionConfiguration lec = conf.getLRUEvictionConfiguration();
        lec.setMaxEntries(1);
        lec.setMaxIdle(1);
        lec.setLifespan(1);
        this.customizeEviction((EntryEvictionConfiguration)lec);
        Cache cache = factory.newCache((CacheConfiguration)conf);
        Assert.assertNotNull((Object)cache);
        if (this.supportEvictionEvent) {
            CacheEntryListenerTest eventListener = new CacheEntryListenerTest();
            cache.addCacheEntryListener((CacheEntryListener)eventListener);
        } else {
            Object eventListener = null;
        }
        cache.set("key", (Object)"value");
        Assert.assertEquals((Object)"value", (Object)cache.get("key"));
        cache.set("key2", (Object)2);
        Assert.assertNull((Object)cache.get("key"));
        Assert.assertEquals((Object)2, (Object)cache.get("key2"));
        Thread.sleep(1100L);
        Assert.assertNull((Object)cache.get("key"));
        Assert.assertNull((Object)cache.get("key2"));
        cache.dispose();
    }
}

