/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.cache.infinispan.internal;

import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntriesEvicted;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryExpired;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntriesEvictedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryExpiredEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.cache.infinispan.internal.InfinispanCacheEntry;
import org.xwiki.cache.infinispan.internal.event.InfinispanCacheEntryEvent;
import org.xwiki.cache.util.AbstractCache;

@Listener
public class InfinispanCache<T>
extends AbstractCache<T> {
    private Cache<String, T> cache;
    private EmbeddedCacheManager cacheManager;

    InfinispanCache(EmbeddedCacheManager cacheManager, CacheConfiguration configuration, Configuration infinispanConfiguration) {
        super(configuration);
        this.cacheManager = cacheManager;
        this.cache = cacheManager.createCache(configuration.getConfigurationId(), infinispanConfiguration);
        this.cache.addListener((Object)this);
    }

    public void remove(String key) {
        this.cache.remove((Object)key);
    }

    public void set(String key, T obj) {
        if (obj != null) {
            this.cache.put((Object)key, obj);
        } else {
            this.cache.remove((Object)key);
        }
    }

    public T get(String key) {
        return (T)this.cache.get((Object)key);
    }

    public void removeAll() {
        this.cache.clear();
    }

    public void dispose() {
        this.removeAll();
        this.cacheManager.administration().removeCache(this.cache.getName());
        super.dispose();
    }

    @CacheEntriesEvicted
    public void nodeEvicted(CacheEntriesEvictedEvent<String, T> event) {
        for (Map.Entry entry : event.getEntries().entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            this.cacheEntryRemoved(key, value);
        }
    }

    @CacheEntryExpired
    public void nodeExpired(CacheEntryExpiredEvent<String, T> event) {
        String key = (String)event.getKey();
        Object value = event.getValue();
        this.cacheEntryRemoved(key, value);
    }

    @CacheEntryRemoved
    public void nodeRemoved(CacheEntryRemovedEvent<String, T> event) {
        Object oldValue;
        if (!event.isPre() && (oldValue = event.getOldValue()) != null) {
            this.cacheEntryRemoved((String)event.getKey(), event.getOldValue());
        }
    }

    @CacheEntryCreated
    public void nodeCreated(CacheEntryCreatedEvent<String, T> event) {
        String key = (String)event.getKey();
        if (!event.isPre()) {
            this.cacheEntryAdded(key, event.getValue());
        }
    }

    @CacheEntryModified
    public void nodeModified(CacheEntryModifiedEvent<String, T> event) {
        String key = (String)event.getKey();
        if (!event.isPre()) {
            Object oldValue = event.getOldValue();
            if (oldValue != null) {
                this.disposeCacheValue(oldValue);
            }
            this.cacheEntryModified(key, event.getNewValue());
        }
    }

    private void cacheEntryAdded(String key, T value) {
        InfinispanCacheEntryEvent<T> event = new InfinispanCacheEntryEvent<T>(new InfinispanCacheEntry<T>(this, key, value));
        this.sendEntryAddedEvent(event);
    }

    private void cacheEntryModified(String key, T value) {
        InfinispanCacheEntryEvent<T> event = new InfinispanCacheEntryEvent<T>(new InfinispanCacheEntry<T>(this, key, value));
        this.sendEntryModifiedEvent(event);
    }

    private void cacheEntryRemoved(String key, T value) {
        InfinispanCacheEntryEvent<T> event = new InfinispanCacheEntryEvent<T>(new InfinispanCacheEntry<T>(this, key, value));
        this.sendEntryRemovedEvent(event);
    }
}

