/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.cache.internal;

import com.google.common.util.concurrent.Uninterruptibles;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import org.apache.commons.lang3.function.FailableBiConsumer;
import org.apache.commons.lang3.function.FailableFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheLoader<V, E extends Exception> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheLoader.class);
    private final ConcurrentHashMap<String, LoaderEntry> currentLoads = new ConcurrentHashMap();
    private final ReadWriteLock invalidationLock = new ReentrantReadWriteLock();
    private final ThreadLocal<LoaderEntry> currentLoad = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V loadAndStoreInCache(String key, FailableFunction<String, V, E> loader, FailableBiConsumer<String, V, E> setter) throws ExecutionException {
        LoaderEntry newEntry = new LoaderEntry(key, loader);
        LoaderEntry loaderEntry = this.getOrInsertLoaderEntry(key, newEntry);
        if (loaderEntry == newEntry) {
            try {
                this.runLoader(loaderEntry);
                Object value = Uninterruptibles.getUninterruptibly(loaderEntry.future);
                loaderEntry.maybeRunSetter(setter, key, value);
                Object object = value;
                return (V)object;
            }
            finally {
                this.currentLoads.computeIfPresent(key, (k, v) -> v == loaderEntry ? null : v);
            }
        }
        return (V)Uninterruptibles.getUninterruptibly(loaderEntry.future);
    }

    private LoaderEntry getOrInsertLoaderEntry(String key, LoaderEntry newEntry) {
        LoaderEntry loaderEntry = this.currentLoads.compute(key, (k, value) -> {
            if (value != null) {
                if (value.creatingThread != Thread.currentThread()) {
                    return value;
                }
                value.invalidated = true;
            }
            return newEntry;
        });
        if (loaderEntry != newEntry && this.currentLoad.get() != null) {
            loaderEntry = newEntry;
            loaderEntry.invalidated = true;
        }
        return loaderEntry;
    }

    private void runLoader(LoaderEntry loaderEntry) {
        LoaderEntry activeLoaderEntry = this.currentLoad.get();
        try {
            this.currentLoad.set(loaderEntry);
            loaderEntry.future.run();
        }
        finally {
            if (activeLoaderEntry == null) {
                this.currentLoad.remove();
            } else {
                this.currentLoad.set(activeLoaderEntry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate(String key, Consumer<String> invalidate) {
        Lock lock = this.invalidationLock.writeLock();
        lock.lock();
        try {
            LoaderEntry entry = this.currentLoads.remove(key);
            if (entry != null) {
                entry.invalidated = true;
            }
            invalidate.accept(key);
        }
        finally {
            lock.unlock();
        }
    }

    public void invalidateAll(Runnable invalidateAll) {
        Lock lock = this.invalidationLock.writeLock();
        lock.lock();
        try {
            this.currentLoads.forEach((k, v) -> {
                this.currentLoads.remove(k);
                v.invalidated = true;
            });
            invalidateAll.run();
        }
        finally {
            lock.unlock();
        }
    }

    private class LoaderEntry {
        private final Thread creatingThread = Thread.currentThread();
        private final FutureTask<V> future = new FutureTask<Object>(() -> loader.apply((Object)key));
        private volatile boolean invalidated;

        LoaderEntry(String key, FailableFunction<String, V, E> loader) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void maybeRunSetter(FailableBiConsumer<String, V, E> setter, String key, V value) {
            if (!this.invalidated) {
                Lock lock = CacheLoader.this.invalidationLock.readLock();
                lock.lock();
                try {
                    if (!this.invalidated) {
                        setter.accept((Object)key, value);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Error setting value for key [{}] on cache.", (Object)key, (Object)e);
                }
                finally {
                    lock.unlock();
                }
            }
        }
    }
}

