/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.blame.script;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.blame.AnnotatedContent;
import org.xwiki.blame.BlameManager;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.diff.display.Splitter;
import org.xwiki.script.service.ScriptService;
import org.xwiki.stability.Unstable;

@Component
@Named(value="blame")
@Singleton
@Unstable
public class BlameScriptService
implements ScriptService {
    static final String BLAME_ERROR_KEY = "scriptservice.blame.error";
    @Inject
    private Execution execution;
    @Inject
    @Named(value="line")
    private Splitter<String, String> lineSplitter;
    @Inject
    private BlameManager blameManager;

    public <R, E> AnnotatedContent<R, E> blame(AnnotatedContent<R, E> content, R revision, List<E> previous) {
        this.setError(null);
        try {
            return this.blameManager.blame(content, revision, previous);
        }
        catch (Exception e) {
            this.setError(e);
            return null;
        }
    }

    public <R> AnnotatedContent<R, String> blame(AnnotatedContent<R, String> content, R revision, String previous) {
        this.setError(null);
        try {
            return this.blameManager.blame(content, revision, this.lineSplitter.split((Object)previous));
        }
        catch (Exception e) {
            this.setError(e);
            return null;
        }
    }

    public Exception getLastError() {
        return (Exception)this.execution.getContext().getProperty(BLAME_ERROR_KEY);
    }

    private void setError(Exception e) {
        this.execution.getContext().setProperty(BLAME_ERROR_KEY, (Object)e);
    }
}

