package org.xrpl.xrpl4j.codec.binary.definitions;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.codec.binary.FieldHeader;

/**
 * Immutable implementation of {@link FieldInstance}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFieldInstance.builder()}.
 */
@Generated(from = "FieldInstance", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableFieldInstance implements FieldInstance {
  private final int nth;
  private final boolean isSigningField;
  private final boolean isSerialized;
  private final String name;
  private final String type;
  private final boolean isVariableLengthEncoded;
  private final FieldHeader header;

  private ImmutableFieldInstance(
      int nth,
      boolean isSigningField,
      boolean isSerialized,
      String name,
      String type,
      boolean isVariableLengthEncoded,
      FieldHeader header) {
    this.nth = nth;
    this.isSigningField = isSigningField;
    this.isSerialized = isSerialized;
    this.name = name;
    this.type = type;
    this.isVariableLengthEncoded = isVariableLengthEncoded;
    this.header = header;
  }

  /**
   * Sort order position for fields of the same type. For example, "Fee" has a type "Amount" and has a sort order of
   * 8th.
   * @return An int with the nth value.
   */
  @Override
  public int nth() {
    return nth;
  }

  /**
   * If field is included in signed transactions.
   * @return {@code true} if this is a signing field; {@code false} otherwise.
   */
  @Override
  public boolean isSigningField() {
    return isSigningField;
  }

  /**
   * If field is included in binary serialized representation.
   * @return {@code true} if this FieldInof is serialized; {@code false} otherwise.
   */
  @Override
  public boolean isSerialized() {
    return isSerialized;
  }

  /**
   * Field name.
   * @return A {@link String} representing the name of this FieldInstance.
   */
  @Override
  public String name() {
    return name;
  }

  /**
   * XRPL type (e.g. UInt32, AccountID, etc).
   * @return A {@link String} representing the type of this FieldInstance.
   */
  @Override
  public String type() {
    return type;
  }

  /**
   * Whether or not this FieldInstance is variable-length encoded.
   * @return {@code true} this FieldInstance is variable-length encoded; {@code false} otherwise.
   */
  @Override
  public boolean isVariableLengthEncoded() {
    return isVariableLengthEncoded;
  }

  /**
   * The {@link FieldHeader} for this {@link FieldInstance}.
   * @return A {@link FieldHeader} for this {@link FieldInstance}.
   */
  @Override
  public FieldHeader header() {
    return header;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FieldInstance#nth() nth} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nth
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFieldInstance withNth(int value) {
    if (this.nth == value) return this;
    return new ImmutableFieldInstance(
        value,
        this.isSigningField,
        this.isSerialized,
        this.name,
        this.type,
        this.isVariableLengthEncoded,
        this.header);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FieldInstance#isSigningField() isSigningField} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isSigningField
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFieldInstance withIsSigningField(boolean value) {
    if (this.isSigningField == value) return this;
    return new ImmutableFieldInstance(
        this.nth,
        value,
        this.isSerialized,
        this.name,
        this.type,
        this.isVariableLengthEncoded,
        this.header);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FieldInstance#isSerialized() isSerialized} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isSerialized
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFieldInstance withIsSerialized(boolean value) {
    if (this.isSerialized == value) return this;
    return new ImmutableFieldInstance(
        this.nth,
        this.isSigningField,
        value,
        this.name,
        this.type,
        this.isVariableLengthEncoded,
        this.header);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FieldInstance#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFieldInstance withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableFieldInstance(
        this.nth,
        this.isSigningField,
        this.isSerialized,
        newValue,
        this.type,
        this.isVariableLengthEncoded,
        this.header);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FieldInstance#type() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFieldInstance withType(String value) {
    String newValue = Objects.requireNonNull(value, "type");
    if (this.type.equals(newValue)) return this;
    return new ImmutableFieldInstance(
        this.nth,
        this.isSigningField,
        this.isSerialized,
        this.name,
        newValue,
        this.isVariableLengthEncoded,
        this.header);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FieldInstance#isVariableLengthEncoded() isVariableLengthEncoded} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isVariableLengthEncoded
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFieldInstance withIsVariableLengthEncoded(boolean value) {
    if (this.isVariableLengthEncoded == value) return this;
    return new ImmutableFieldInstance(this.nth, this.isSigningField, this.isSerialized, this.name, this.type, value, this.header);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FieldInstance#header() header} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for header
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFieldInstance withHeader(FieldHeader value) {
    if (this.header == value) return this;
    FieldHeader newValue = Objects.requireNonNull(value, "header");
    return new ImmutableFieldInstance(
        this.nth,
        this.isSigningField,
        this.isSerialized,
        this.name,
        this.type,
        this.isVariableLengthEncoded,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFieldInstance} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFieldInstance
        && equalTo((ImmutableFieldInstance) another);
  }

  private boolean equalTo(ImmutableFieldInstance another) {
    return nth == another.nth
        && isSigningField == another.isSigningField
        && isSerialized == another.isSerialized
        && name.equals(another.name)
        && type.equals(another.type)
        && isVariableLengthEncoded == another.isVariableLengthEncoded
        && header.equals(another.header);
  }

  /**
   * Computes a hash code from attributes: {@code nth}, {@code isSigningField}, {@code isSerialized}, {@code name}, {@code type}, {@code isVariableLengthEncoded}, {@code header}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + nth;
    h += (h << 5) + Booleans.hashCode(isSigningField);
    h += (h << 5) + Booleans.hashCode(isSerialized);
    h += (h << 5) + name.hashCode();
    h += (h << 5) + type.hashCode();
    h += (h << 5) + Booleans.hashCode(isVariableLengthEncoded);
    h += (h << 5) + header.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code FieldInstance} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("FieldInstance")
        .omitNullValues()
        .add("nth", nth)
        .add("isSigningField", isSigningField)
        .add("isSerialized", isSerialized)
        .add("name", name)
        .add("type", type)
        .add("isVariableLengthEncoded", isVariableLengthEncoded)
        .add("header", header)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link FieldInstance} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable FieldInstance instance
   */
  public static ImmutableFieldInstance copyOf(FieldInstance instance) {
    if (instance instanceof ImmutableFieldInstance) {
      return (ImmutableFieldInstance) instance;
    }
    return ImmutableFieldInstance.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFieldInstance ImmutableFieldInstance}.
   * <pre>
   * ImmutableFieldInstance.builder()
   *    .nth(int) // required {@link FieldInstance#nth() nth}
   *    .isSigningField(boolean) // required {@link FieldInstance#isSigningField() isSigningField}
   *    .isSerialized(boolean) // required {@link FieldInstance#isSerialized() isSerialized}
   *    .name(String) // required {@link FieldInstance#name() name}
   *    .type(String) // required {@link FieldInstance#type() type}
   *    .isVariableLengthEncoded(boolean) // required {@link FieldInstance#isVariableLengthEncoded() isVariableLengthEncoded}
   *    .header(org.xrpl.xrpl4j.codec.binary.FieldHeader) // required {@link FieldInstance#header() header}
   *    .build();
   * </pre>
   * @return A new ImmutableFieldInstance builder
   */
  public static ImmutableFieldInstance.Builder builder() {
    return new ImmutableFieldInstance.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableFieldInstance ImmutableFieldInstance}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "FieldInstance", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NTH = 0x1L;
    private static final long INIT_BIT_IS_SIGNING_FIELD = 0x2L;
    private static final long INIT_BIT_IS_SERIALIZED = 0x4L;
    private static final long INIT_BIT_NAME = 0x8L;
    private static final long INIT_BIT_TYPE = 0x10L;
    private static final long INIT_BIT_IS_VARIABLE_LENGTH_ENCODED = 0x20L;
    private static final long INIT_BIT_HEADER = 0x40L;
    private long initBits = 0x7fL;

    private int nth;
    private boolean isSigningField;
    private boolean isSerialized;
    private @Nullable String name;
    private @Nullable String type;
    private boolean isVariableLengthEncoded;
    private @Nullable FieldHeader header;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code FieldInstance} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(FieldInstance instance) {
      Objects.requireNonNull(instance, "instance");
      nth(instance.nth());
      isSigningField(instance.isSigningField());
      isSerialized(instance.isSerialized());
      name(instance.name());
      type(instance.type());
      isVariableLengthEncoded(instance.isVariableLengthEncoded());
      header(instance.header());
      return this;
    }

    /**
     * Initializes the value for the {@link FieldInstance#nth() nth} attribute.
     * @param nth The value for nth 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder nth(int nth) {
      this.nth = nth;
      initBits &= ~INIT_BIT_NTH;
      return this;
    }

    /**
     * Initializes the value for the {@link FieldInstance#isSigningField() isSigningField} attribute.
     * @param isSigningField The value for isSigningField 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder isSigningField(boolean isSigningField) {
      this.isSigningField = isSigningField;
      initBits &= ~INIT_BIT_IS_SIGNING_FIELD;
      return this;
    }

    /**
     * Initializes the value for the {@link FieldInstance#isSerialized() isSerialized} attribute.
     * @param isSerialized The value for isSerialized 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder isSerialized(boolean isSerialized) {
      this.isSerialized = isSerialized;
      initBits &= ~INIT_BIT_IS_SERIALIZED;
      return this;
    }

    /**
     * Initializes the value for the {@link FieldInstance#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link FieldInstance#type() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder type(String type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link FieldInstance#isVariableLengthEncoded() isVariableLengthEncoded} attribute.
     * @param isVariableLengthEncoded The value for isVariableLengthEncoded 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder isVariableLengthEncoded(boolean isVariableLengthEncoded) {
      this.isVariableLengthEncoded = isVariableLengthEncoded;
      initBits &= ~INIT_BIT_IS_VARIABLE_LENGTH_ENCODED;
      return this;
    }

    /**
     * Initializes the value for the {@link FieldInstance#header() header} attribute.
     * @param header The value for header 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder header(FieldHeader header) {
      this.header = Objects.requireNonNull(header, "header");
      initBits &= ~INIT_BIT_HEADER;
      return this;
    }

    /**
     * Builds a new {@link ImmutableFieldInstance ImmutableFieldInstance}.
     * @return An immutable instance of FieldInstance
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFieldInstance build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableFieldInstance(nth, isSigningField, isSerialized, name, type, isVariableLengthEncoded, header);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NTH) != 0) attributes.add("nth");
      if ((initBits & INIT_BIT_IS_SIGNING_FIELD) != 0) attributes.add("isSigningField");
      if ((initBits & INIT_BIT_IS_SERIALIZED) != 0) attributes.add("isSerialized");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      if ((initBits & INIT_BIT_IS_VARIABLE_LENGTH_ENCODED) != 0) attributes.add("isVariableLengthEncoded");
      if ((initBits & INIT_BIT_HEADER) != 0) attributes.add("header");
      return "Cannot build FieldInstance, some of required attributes are not set " + attributes;
    }
  }
}
