package org.xrpl.xrpl4j.codec.binary.definitions;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link FieldInfo}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFieldInfo.builder()}.
 */
@Generated(from = "FieldInfo", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableFieldInfo implements FieldInfo {
  private final int nth;
  private final boolean isSigningField;
  private final boolean isSerialized;
  private final String type;
  private final boolean isVariableLengthEncoded;

  private ImmutableFieldInfo(
      int nth,
      boolean isSigningField,
      boolean isSerialized,
      String type,
      boolean isVariableLengthEncoded) {
    this.nth = nth;
    this.isSigningField = isSigningField;
    this.isSerialized = isSerialized;
    this.type = type;
    this.isVariableLengthEncoded = isVariableLengthEncoded;
  }

  /**
   * Sort order position for fields of the same type. For example, "Fee" has a type "Amount" and has a sort order of
   * 8th.
   * @return An int with the nth value.
   */
  @JsonProperty("nth")
  @Override
  public int nth() {
    return nth;
  }

  /**
   * If field is included in signed transactions.
   * @return {@code true} if this is a signing field; {@code false} otherwise.
   */
  @JsonProperty("isSigningField")
  @Override
  public boolean isSigningField() {
    return isSigningField;
  }

  /**
   * If fiels is included in binary serialized representation.
   * @return {@code true} if this FieldInof is serialized; {@code false} otherwise.
   */
  @JsonProperty("isSerialized")
  @Override
  public boolean isSerialized() {
    return isSerialized;
  }

  /**
   * XRPL type (e.g. UInt32, AccountID, etc.)
   * @return A {@link String} representing the type of this FieldInfo.
   */
  @JsonProperty("type")
  @Override
  public String type() {
    return type;
  }

  /**
   * @return The value of the {@code isVariableLengthEncoded} attribute
   */
  @JsonProperty("isVLEncoded")
  @Override
  public boolean isVariableLengthEncoded() {
    return isVariableLengthEncoded;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FieldInfo#nth() nth} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nth
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFieldInfo withNth(int value) {
    if (this.nth == value) return this;
    return new ImmutableFieldInfo(value, this.isSigningField, this.isSerialized, this.type, this.isVariableLengthEncoded);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FieldInfo#isSigningField() isSigningField} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isSigningField
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFieldInfo withIsSigningField(boolean value) {
    if (this.isSigningField == value) return this;
    return new ImmutableFieldInfo(this.nth, value, this.isSerialized, this.type, this.isVariableLengthEncoded);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FieldInfo#isSerialized() isSerialized} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isSerialized
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFieldInfo withIsSerialized(boolean value) {
    if (this.isSerialized == value) return this;
    return new ImmutableFieldInfo(this.nth, this.isSigningField, value, this.type, this.isVariableLengthEncoded);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FieldInfo#type() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFieldInfo withType(String value) {
    String newValue = Objects.requireNonNull(value, "type");
    if (this.type.equals(newValue)) return this;
    return new ImmutableFieldInfo(this.nth, this.isSigningField, this.isSerialized, newValue, this.isVariableLengthEncoded);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FieldInfo#isVariableLengthEncoded() isVariableLengthEncoded} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isVariableLengthEncoded
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFieldInfo withIsVariableLengthEncoded(boolean value) {
    if (this.isVariableLengthEncoded == value) return this;
    return new ImmutableFieldInfo(this.nth, this.isSigningField, this.isSerialized, this.type, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFieldInfo} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFieldInfo
        && equalTo((ImmutableFieldInfo) another);
  }

  private boolean equalTo(ImmutableFieldInfo another) {
    return nth == another.nth
        && isSigningField == another.isSigningField
        && isSerialized == another.isSerialized
        && type.equals(another.type)
        && isVariableLengthEncoded == another.isVariableLengthEncoded;
  }

  /**
   * Computes a hash code from attributes: {@code nth}, {@code isSigningField}, {@code isSerialized}, {@code type}, {@code isVariableLengthEncoded}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + nth;
    h += (h << 5) + Booleans.hashCode(isSigningField);
    h += (h << 5) + Booleans.hashCode(isSerialized);
    h += (h << 5) + type.hashCode();
    h += (h << 5) + Booleans.hashCode(isVariableLengthEncoded);
    return h;
  }

  /**
   * Prints the immutable value {@code FieldInfo} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("FieldInfo")
        .omitNullValues()
        .add("nth", nth)
        .add("isSigningField", isSigningField)
        .add("isSerialized", isSerialized)
        .add("type", type)
        .add("isVariableLengthEncoded", isVariableLengthEncoded)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "FieldInfo", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements FieldInfo {
    int nth;
    boolean nthIsSet;
    boolean isSigningField;
    boolean isSigningFieldIsSet;
    boolean isSerialized;
    boolean isSerializedIsSet;
    @Nullable String type;
    boolean isVariableLengthEncoded;
    boolean isVariableLengthEncodedIsSet;
    @JsonProperty("nth")
    public void setNth(int nth) {
      this.nth = nth;
      this.nthIsSet = true;
    }
    @JsonProperty("isSigningField")
    public void setIsSigningField(boolean isSigningField) {
      this.isSigningField = isSigningField;
      this.isSigningFieldIsSet = true;
    }
    @JsonProperty("isSerialized")
    public void setIsSerialized(boolean isSerialized) {
      this.isSerialized = isSerialized;
      this.isSerializedIsSet = true;
    }
    @JsonProperty("type")
    public void setType(String type) {
      this.type = type;
    }
    @JsonProperty("isVLEncoded")
    public void setIsVariableLengthEncoded(boolean isVariableLengthEncoded) {
      this.isVariableLengthEncoded = isVariableLengthEncoded;
      this.isVariableLengthEncodedIsSet = true;
    }
    @Override
    public int nth() { throw new UnsupportedOperationException(); }
    @Override
    public boolean isSigningField() { throw new UnsupportedOperationException(); }
    @Override
    public boolean isSerialized() { throw new UnsupportedOperationException(); }
    @Override
    public String type() { throw new UnsupportedOperationException(); }
    @Override
    public boolean isVariableLengthEncoded() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableFieldInfo fromJson(Json json) {
    ImmutableFieldInfo.Builder builder = ImmutableFieldInfo.builder();
    if (json.nthIsSet) {
      builder.nth(json.nth);
    }
    if (json.isSigningFieldIsSet) {
      builder.isSigningField(json.isSigningField);
    }
    if (json.isSerializedIsSet) {
      builder.isSerialized(json.isSerialized);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.isVariableLengthEncodedIsSet) {
      builder.isVariableLengthEncoded(json.isVariableLengthEncoded);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link FieldInfo} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable FieldInfo instance
   */
  public static ImmutableFieldInfo copyOf(FieldInfo instance) {
    if (instance instanceof ImmutableFieldInfo) {
      return (ImmutableFieldInfo) instance;
    }
    return ImmutableFieldInfo.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFieldInfo ImmutableFieldInfo}.
   * <pre>
   * ImmutableFieldInfo.builder()
   *    .nth(int) // required {@link FieldInfo#nth() nth}
   *    .isSigningField(boolean) // required {@link FieldInfo#isSigningField() isSigningField}
   *    .isSerialized(boolean) // required {@link FieldInfo#isSerialized() isSerialized}
   *    .type(String) // required {@link FieldInfo#type() type}
   *    .isVariableLengthEncoded(boolean) // required {@link FieldInfo#isVariableLengthEncoded() isVariableLengthEncoded}
   *    .build();
   * </pre>
   * @return A new ImmutableFieldInfo builder
   */
  public static ImmutableFieldInfo.Builder builder() {
    return new ImmutableFieldInfo.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableFieldInfo ImmutableFieldInfo}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "FieldInfo", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NTH = 0x1L;
    private static final long INIT_BIT_IS_SIGNING_FIELD = 0x2L;
    private static final long INIT_BIT_IS_SERIALIZED = 0x4L;
    private static final long INIT_BIT_TYPE = 0x8L;
    private static final long INIT_BIT_IS_VARIABLE_LENGTH_ENCODED = 0x10L;
    private long initBits = 0x1fL;

    private int nth;
    private boolean isSigningField;
    private boolean isSerialized;
    private @Nullable String type;
    private boolean isVariableLengthEncoded;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code FieldInfo} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(FieldInfo instance) {
      Objects.requireNonNull(instance, "instance");
      nth(instance.nth());
      isSigningField(instance.isSigningField());
      isSerialized(instance.isSerialized());
      type(instance.type());
      isVariableLengthEncoded(instance.isVariableLengthEncoded());
      return this;
    }

    /**
     * Initializes the value for the {@link FieldInfo#nth() nth} attribute.
     * @param nth The value for nth 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("nth")
    public final Builder nth(int nth) {
      this.nth = nth;
      initBits &= ~INIT_BIT_NTH;
      return this;
    }

    /**
     * Initializes the value for the {@link FieldInfo#isSigningField() isSigningField} attribute.
     * @param isSigningField The value for isSigningField 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("isSigningField")
    public final Builder isSigningField(boolean isSigningField) {
      this.isSigningField = isSigningField;
      initBits &= ~INIT_BIT_IS_SIGNING_FIELD;
      return this;
    }

    /**
     * Initializes the value for the {@link FieldInfo#isSerialized() isSerialized} attribute.
     * @param isSerialized The value for isSerialized 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("isSerialized")
    public final Builder isSerialized(boolean isSerialized) {
      this.isSerialized = isSerialized;
      initBits &= ~INIT_BIT_IS_SERIALIZED;
      return this;
    }

    /**
     * Initializes the value for the {@link FieldInfo#type() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("type")
    public final Builder type(String type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link FieldInfo#isVariableLengthEncoded() isVariableLengthEncoded} attribute.
     * @param isVariableLengthEncoded The value for isVariableLengthEncoded 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("isVLEncoded")
    public final Builder isVariableLengthEncoded(boolean isVariableLengthEncoded) {
      this.isVariableLengthEncoded = isVariableLengthEncoded;
      initBits &= ~INIT_BIT_IS_VARIABLE_LENGTH_ENCODED;
      return this;
    }

    /**
     * Builds a new {@link ImmutableFieldInfo ImmutableFieldInfo}.
     * @return An immutable instance of FieldInfo
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFieldInfo build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableFieldInfo(nth, isSigningField, isSerialized, type, isVariableLengthEncoded);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NTH) != 0) attributes.add("nth");
      if ((initBits & INIT_BIT_IS_SIGNING_FIELD) != 0) attributes.add("isSigningField");
      if ((initBits & INIT_BIT_IS_SERIALIZED) != 0) attributes.add("isSerialized");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      if ((initBits & INIT_BIT_IS_VARIABLE_LENGTH_ENCODED) != 0) attributes.add("isVariableLengthEncoded");
      return "Cannot build FieldInfo, some of required attributes are not set " + attributes;
    }
  }
}
