/**
 *  Copyright 2015 Sven Ewald
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.xmlbeam.evaluation;

import java.io.IOException;

import org.w3c.dom.Document;

/**
 * @author sven
 */
public interface DocumentResolver {

    /**
     * Resolve document, possibly using the given class.
     *
     * @param resourceAwareClasses
     *            may provide a class loader, may be null.
     * @return a dom Document
     * @throws IOException
     */
    Document resolve(Class<?>... resourceAwareClasses) throws IOException;
   
}
