/*
 * Decompiled with CFR 0.152.
 */
package org.xmlbeam.exceptions;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedList;
import org.xmlbeam.exceptions.XBException;

public class XBPathException
extends XBException {
    private static final long serialVersionUID = -2286603725835988440L;
    private final CharSequence resolvedXpath;

    public XBPathException(String msg, Method method, CharSequence xpath) {
        super((CharSequence)(msg + " when invoking " + XBPathException.shortDesc(method) + " [Resolved XPath:'" + xpath + "']"));
        this.resolvedXpath = xpath;
        this.stripStackTrace();
    }

    public XBPathException(Throwable cause, Method method, CharSequence xpath) {
        super("Exception invocating " + XBPathException.shortDesc(method) + " [Resolved XPath:'" + xpath + "']", cause);
        this.resolvedXpath = xpath;
        this.stripStackTrace();
    }

    public XBPathException(Throwable cause, CharSequence xpath) {
        super("Exception evaluating '" + xpath + "'", cause);
        this.resolvedXpath = xpath;
        this.stripStackTrace();
    }

    private void stripStackTrace() {
        LinkedList<StackTraceElement> st = new LinkedList<StackTraceElement>(Arrays.asList(this.getStackTrace()));
        st.remove(0);
        st.remove(0);
        this.setStackTrace(st.toArray(new StackTraceElement[st.size()]));
    }

    private static String shortDesc(Method method) {
        String params = "";
        for (Class<?> c : method.getParameterTypes()) {
            if (!params.isEmpty()) {
                params = ", ";
            }
            params = params + c.getSimpleName();
        }
        return method.getDeclaringClass().getSimpleName() + "." + method.getName() + "(" + params + ")";
    }

    public String getResolvedXpath() {
        return this.resolvedXpath.toString();
    }
}

