/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.swt;

import com.google.errorprone.annotations.CheckReturnValue;
import java.awt.BasicStroke;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.jspecify.annotations.NullUnmarked;
import org.jspecify.annotations.Nullable;
import org.xhtmlrenderer.css.parser.FSColor;
import org.xhtmlrenderer.css.parser.FSRGBColor;
import org.xhtmlrenderer.extend.FSImage;
import org.xhtmlrenderer.extend.ReplacedElement;
import org.xhtmlrenderer.render.AbstractOutputDevice;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.render.FSFont;
import org.xhtmlrenderer.render.InlineText;
import org.xhtmlrenderer.render.RenderingContext;
import org.xhtmlrenderer.swt.FormControlReplacementElement;
import org.xhtmlrenderer.swt.ImageReplacedElement;
import org.xhtmlrenderer.swt.SWTFSFont;
import org.xhtmlrenderer.swt.SWTFSImage;
import org.xhtmlrenderer.swt.simple.SWTFormControl;

@NullUnmarked
public class SWTOutputDevice
extends AbstractOutputDevice {
    private final GC _gc;
    private Path _clippingPath = null;
    private Area _clippingArea = null;
    private Color _color = null;
    private java.awt.Color _awt_color = null;
    private Transform _transform = null;
    private Stroke _stroke = null;

    public SWTOutputDevice(GC gc) {
        this._gc = gc;
    }

    public GC getGC() {
        return this._gc;
    }

    public void clean() {
        if (this._clippingPath != null) {
            this._gc.setClipping((Rectangle)null);
            this._clippingPath.dispose();
            this._clippingPath = null;
            this._clippingArea = null;
        }
        if (this._color != null) {
            this._color.dispose();
            this._color = null;
        }
        if (this._transform != null) {
            this._gc.setTransform(null);
            this._transform.dispose();
        }
    }

    public void clip(Shape s) {
        if (s == null) {
            return;
        }
        if (this._clippingArea == null) {
            this.setClip(s);
        } else {
            Area a = new Area(this._clippingArea);
            a.intersect(new Area(s));
            this.setClip(a);
        }
    }

    public void setClip(Shape s) {
        Path path = this.convertToPath(s);
        if (path == null) {
            this._gc.setClipping((Rectangle)null);
        } else {
            this._gc.setClipping(path);
        }
        if (this._clippingPath != null) {
            this._clippingPath.dispose();
        }
        this._clippingPath = path;
        this._clippingArea = s == null ? null : new Area(s);
    }

    @CheckReturnValue
    public @Nullable Shape getClip() {
        return this._clippingArea;
    }

    protected void drawLine(int x1, int y1, int x2, int y2) {
        this._gc.drawLine(x1, y1, x2, y2);
    }

    public void drawBorderLine(Shape bounds, int side, int lineWidth, boolean solid) {
        this.draw(bounds);
    }

    public void drawImage(FSImage image, int x, int y) {
        Image img = ((SWTFSImage)image).getImage();
        if (img == null) {
            int width = image.getWidth();
            int height = image.getHeight();
            Color oldBG = this._gc.getBackground();
            Color oldFG = this._gc.getForeground();
            this._gc.setBackground(this._gc.getDevice().getSystemColor(1));
            this._gc.setForeground(this._gc.getDevice().getSystemColor(2));
            this._gc.fillRectangle(x, y, width, height);
            this._gc.drawRectangle(x, y, width, height);
            this._gc.drawLine(x, y, x + width - 1, y + height - 1);
            this._gc.drawLine(x, y + height - 1, x + width - 1, y);
            this._gc.setBackground(oldBG);
            this._gc.setForeground(oldFG);
        } else {
            Rectangle bounds = img.getBounds();
            this._gc.drawImage(img, 0, 0, bounds.width, bounds.height, x, y, image.getWidth(), image.getHeight());
        }
    }

    public void drawOval(int x, int y, int width, int height) {
        this._gc.drawOval(x, y, width, height);
    }

    public void drawRect(int x, int y, int width, int height) {
        this._gc.drawRectangle(x, y, width, height);
    }

    public void draw(Shape s) {
        Path p = this.convertToPath(s);
        this._gc.drawPath(p);
        p.dispose();
    }

    public void fill(Shape s) {
        Path p = this.convertToPath(s);
        this._gc.fillPath(p);
        p.dispose();
    }

    public void fillOval(int x, int y, int width, int height) {
        this._gc.fillOval(x, y, width, height);
    }

    public void fillRect(int x, int y, int width, int height) {
        this._gc.fillRectangle(x, y, width, height);
    }

    public void paintReplacedElement(RenderingContext c, BlockBox box) {
        ReplacedElement replaced = box.getReplacedElement();
        Point location = replaced.getLocation();
        if (replaced instanceof ImageReplacedElement) {
            this.drawImage(((ImageReplacedElement)replaced).getImage(), location.x, location.y);
        } else if (replaced instanceof FormControlReplacementElement) {
            SWTFormControl swtControl = ((FormControlReplacementElement)replaced).getControl();
            swtControl.getSWTControl().setVisible(true);
        }
    }

    public void setColor(java.awt.Color color) {
        if (color.equals(this._awt_color)) {
            return;
        }
        Color col = new Color(this._gc.getDevice(), color.getRed(), color.getGreen(), color.getBlue());
        this._gc.setForeground(col);
        this._gc.setBackground(col);
        this._gc.setAlpha(color.getAlpha());
        if (this._color != null) {
            this._color.dispose();
        }
        this._color = col;
        this._awt_color = color;
    }

    public void setFont(FSFont font) {
        this._gc.setFont(((SWTFSFont)font).getSWTFont());
    }

    public void setColor(FSColor color) {
        if (!(color instanceof FSRGBColor)) {
            throw new RuntimeException("internal error: unsupported color class " + color.getClass().getName());
        }
        FSRGBColor rgb = (FSRGBColor)color;
        this.setColor(new java.awt.Color(rgb.getRed(), rgb.getGreen(), rgb.getBlue()));
    }

    public Stroke getStroke() {
        return this._stroke;
    }

    public void setStroke(Stroke s) {
        this._stroke = s;
        if (s == null) {
            this._gc.setLineWidth(1);
            this._gc.setLineCap(3);
            this._gc.setLineJoin(1);
            this._gc.setLineDash(null);
            return;
        }
        if (!(s instanceof BasicStroke)) {
            return;
        }
        BasicStroke bs = (BasicStroke)s;
        this._gc.setLineWidth((int)bs.getLineWidth());
        int gcCap = switch (bs.getEndCap()) {
            case 0 -> 1;
            case 1 -> 2;
            case 2 -> 3;
            default -> 3;
        };
        this._gc.setLineCap(gcCap);
        int gcJoin = switch (bs.getLineJoin()) {
            case 2 -> 3;
            case 0 -> 1;
            case 1 -> 2;
            default -> 1;
        };
        this._gc.setLineJoin(gcJoin);
        float[] d = bs.getDashArray();
        int[] dashes = null;
        if (d != null) {
            dashes = new int[d.length];
            for (int i = 0; i < d.length; ++i) {
                dashes[i] = (int)d[i];
            }
        }
        this._gc.setLineDash(dashes);
    }

    public void translate(double tx, double ty) {
        if (this._transform == null) {
            this._transform = new Transform(this._gc.getDevice());
        }
        this._transform.translate((float)((int)tx), (float)((int)ty));
        this._gc.setTransform(this._transform);
        if (this._clippingArea != null) {
            AffineTransform t = new AffineTransform();
            t.translate(-tx, -ty);
            this._clippingArea.transform(t);
        }
    }

    @CheckReturnValue
    public @Nullable Object getRenderingHint(RenderingHints.Key key) {
        if (RenderingHints.KEY_ANTIALIASING.equals(key)) {
            switch (this._gc.getAntialias()) {
                case -1: {
                    return RenderingHints.VALUE_ANTIALIAS_DEFAULT;
                }
                case 0: {
                    return RenderingHints.VALUE_ANTIALIAS_OFF;
                }
                case 1: {
                    return RenderingHints.VALUE_ANTIALIAS_ON;
                }
            }
        }
        return null;
    }

    public void setRenderingHint(RenderingHints.Key key, Object value) {
        if (RenderingHints.KEY_ANTIALIASING.equals(key)) {
            int antialias = -1;
            if (RenderingHints.VALUE_ANTIALIAS_OFF.equals(value)) {
                antialias = 0;
            } else if (RenderingHints.VALUE_ANTIALIAS_ON.equals(value)) {
                antialias = 1;
            }
            this._gc.setAntialias(antialias);
        }
    }

    private @Nullable Path convertToPath(Shape shape) {
        if (shape == null) {
            return null;
        }
        Path path = new Path(this._gc.getDevice());
        PathIterator iter = shape.getPathIterator(null);
        float[] coords = new float[6];
        while (!iter.isDone()) {
            int op = iter.currentSegment(coords);
            switch (op) {
                case 0: {
                    path.moveTo(coords[0], coords[1]);
                    break;
                }
                case 1: {
                    path.lineTo(coords[0], coords[1]);
                    break;
                }
                case 2: {
                    path.quadTo(coords[0], coords[1], coords[2], coords[3]);
                    break;
                }
                case 3: {
                    path.cubicTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                    break;
                }
                case 4: {
                    path.close();
                }
            }
            iter.next();
        }
        return path;
    }

    public void drawSelection(RenderingContext c, InlineText inlineText) {
    }

    public boolean isSupportsSelection() {
        return false;
    }

    public boolean isSupportsCMYKColors() {
        return false;
    }
}

