/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.swt;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xhtmlrenderer.css.style.CssContext;
import org.xhtmlrenderer.css.style.derived.RectPropertySet;
import org.xhtmlrenderer.event.DocumentListener;
import org.xhtmlrenderer.extend.FSCanvas;
import org.xhtmlrenderer.extend.FontContext;
import org.xhtmlrenderer.extend.FontResolver;
import org.xhtmlrenderer.extend.NamespaceHandler;
import org.xhtmlrenderer.extend.OutputDevice;
import org.xhtmlrenderer.extend.ReplacedElementFactory;
import org.xhtmlrenderer.extend.TextRenderer;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.extend.UserInterface;
import org.xhtmlrenderer.layout.BoxBuilder;
import org.xhtmlrenderer.layout.Layer;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.layout.SharedContext;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.render.Box;
import org.xhtmlrenderer.render.PageBox;
import org.xhtmlrenderer.render.RenderingContext;
import org.xhtmlrenderer.render.ViewportBox;
import org.xhtmlrenderer.resource.XMLResource;
import org.xhtmlrenderer.simple.NoNamespaceHandler;
import org.xhtmlrenderer.swt.NaiveUserAgent;
import org.xhtmlrenderer.swt.SWTFontContext;
import org.xhtmlrenderer.swt.SWTFontResolver;
import org.xhtmlrenderer.swt.SWTOutputDevice;
import org.xhtmlrenderer.swt.SWTReplacedElementFactory;
import org.xhtmlrenderer.swt.SWTTextRenderer;
import org.xhtmlrenderer.util.Configuration;
import org.xhtmlrenderer.util.Uu;
import org.xhtmlrenderer.util.XRLog;
import org.xml.sax.InputSource;

public class BasicRenderer
extends Canvas
implements PaintListener,
UserInterface,
FSCanvas {
    private static final int PAGE_PAINTING_CLEARANCE = 10;
    private SharedContext _sharedContext;
    private LayoutContext _layout_context;
    private Image _layout_image = null;
    private GC _layout_gc = null;
    private float _fontScalingFactor = 1.2f;
    private float _minFontScale = 0.5f;
    private float _maxFontScale = 3.0f;
    private Document _doc = null;
    private BlockBox _rootBox = null;
    private Set _documentListeners = new HashSet();
    private boolean _needRelayout = false;
    private boolean _hasFixedContent = false;
    private boolean _noResize = false;
    private Point _origin = new Point(0, 0);
    private Point _drawnSize = new Point(0, 0);
    private Image _offscreen = null;
    private SpecialRedraw _specialRedraw = null;
    private Element _hovered_element = null;
    private Element _active_element = null;
    private Element _focus_element = null;

    private static int checkStyle(int style) {
        int mask = 2048;
        return style & 0x800 | 0x100000 | 0x40000 | 0x200 | 0x100 | 0x400000;
    }

    public BasicRenderer(Composite parent, int style) {
        this(parent, style, new NaiveUserAgent((Device)parent.getDisplay()));
    }

    public BasicRenderer(Composite parent, int style, UserAgentCallback uac) {
        super(parent, BasicRenderer.checkStyle(style));
        super.setLayout(null);
        this.setBackground(this.getDisplay().getSystemColor(1));
        this.setBackgroundMode(2);
        this._sharedContext = new SharedContext(uac, (FontResolver)new SWTFontResolver((Device)parent.getDisplay()), (ReplacedElementFactory)new SWTReplacedElementFactory(), (TextRenderer)new SWTTextRenderer(), (float)this.getDisplay().getDPI().y);
        this._sharedContext.setCanvas((FSCanvas)this);
        this.getHorizontalBar().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ScrollBar bar = (ScrollBar)event.widget;
                int hSelection = bar.getSelection();
                BasicRenderer.this.scrollTo(new Point(hSelection, ((BasicRenderer)BasicRenderer.this)._origin.y));
            }
        });
        this.getVerticalBar().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ScrollBar bar = (ScrollBar)event.widget;
                int vSelection = bar.getSelection();
                BasicRenderer.this.scrollTo(new Point(((BasicRenderer)BasicRenderer.this)._origin.x, vSelection));
            }
        });
        this.addPaintListener(this);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                UserAgentCallback uac;
                BasicRenderer.this._sharedContext.flushFonts();
                ReplacedElementFactory ref = BasicRenderer.this._sharedContext.getReplacedElementFactory();
                if (ref instanceof SWTReplacedElementFactory) {
                    ((SWTReplacedElementFactory)ref).clean();
                }
                if ((uac = BasicRenderer.this._sharedContext.getUac()) instanceof NaiveUserAgent) {
                    ((NaiveUserAgent)uac).disposeCache();
                }
                if (BasicRenderer.this._offscreen != null) {
                    BasicRenderer.this._offscreen.dispose();
                }
                if (BasicRenderer.this._layout_image != null) {
                    BasicRenderer.this._layout_gc.dispose();
                    BasicRenderer.this._layout_image.dispose();
                }
            }
        });
        this.addListener(11, new Listener(){
            private Point _previousSize = null;

            public void handleEvent(Event event) {
                Point size = BasicRenderer.this.getScreenSize();
                if (BasicRenderer.this.getRootLayer() != null && !BasicRenderer.this._noResize) {
                    if (!(BasicRenderer.this.isPrint() || this._previousSize != null && size.x == this._previousSize.x)) {
                        BasicRenderer.this.relayout();
                    } else if (BasicRenderer.this.updateScrollBars()) {
                        BasicRenderer.this.relayout();
                    } else if (BasicRenderer.this._offscreen != null) {
                        BasicRenderer.this.redrawSpecial(new RedrawNewSize(this._previousSize));
                    }
                }
                this._previousSize = size;
            }
        });
        this.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                Point pt = new Point(((BasicRenderer)BasicRenderer.this)._origin.x, ((BasicRenderer)BasicRenderer.this)._origin.y);
                switch (e.keyCode) {
                    case 0x1000001: {
                        pt.y -= BasicRenderer.this.getVerticalBar().getIncrement();
                        break;
                    }
                    case 0x1000002: {
                        pt.y += BasicRenderer.this.getVerticalBar().getIncrement();
                        break;
                    }
                    case 0x1000003: {
                        pt.x -= BasicRenderer.this.getHorizontalBar().getIncrement();
                        break;
                    }
                    case 0x1000004: {
                        pt.x += BasicRenderer.this.getHorizontalBar().getIncrement();
                        break;
                    }
                    case 0x1000005: {
                        pt.y -= BasicRenderer.this.getVerticalBar().getPageIncrement();
                        break;
                    }
                    case 0x1000006: {
                        pt.y += BasicRenderer.this.getVerticalBar().getPageIncrement();
                        break;
                    }
                    case 0x1000007: {
                        pt.x = 0;
                        pt.y = 0;
                        break;
                    }
                    case 0x1000008: {
                        pt.x = 0;
                        pt.y = ((BasicRenderer)BasicRenderer.this)._drawnSize.y;
                    }
                }
                BasicRenderer.this.setOrigin(pt);
            }
        });
        this.updateScrollBars();
    }

    public void addDocumentListener(DocumentListener listener) {
        this._documentListeners.add(listener);
    }

    public void removeDocumentListener(DocumentListener listener) {
        this._documentListeners.remove(listener);
    }

    protected void fireDocumentLoaded() {
        Iterator it = this._documentListeners.iterator();
        while (it.hasNext()) {
            ((DocumentListener)it.next()).documentLoaded();
        }
    }

    protected void fireOnLayoutException(Throwable t) {
        Iterator it = this._documentListeners.iterator();
        while (it.hasNext()) {
            ((DocumentListener)it.next()).onLayoutException(t);
        }
    }

    protected void fireOnRenderException(Throwable t) {
        Iterator it = this._documentListeners.iterator();
        while (it.hasNext()) {
            ((DocumentListener)it.next()).onRenderException(t);
        }
    }

    public void setLayout(Layout layout) {
    }

    public void relayout() {
        this._needRelayout = true;
        this.redraw();
    }

    public void invalidate() {
        if (this._offscreen != null) {
            this._offscreen.dispose();
            this._offscreen = null;
        }
        this.redraw();
    }

    private void redrawSpecial(SpecialRedraw type) {
        if (this._hasFixedContent && !type.isForFixedContent()) {
            this.invalidate();
        } else if (this._specialRedraw == null) {
            this._specialRedraw = type;
            this._specialRedraw.redraw();
        } else if (this._specialRedraw.getClass().equals(type.getClass()) && this._specialRedraw.ignoreFurther()) {
            this._specialRedraw.redraw();
        } else {
            this.invalidate();
        }
    }

    public void invalidate(org.eclipse.swt.graphics.Rectangle rect) {
        org.eclipse.swt.graphics.Rectangle r = this.getClientArea();
        r.intersect(rect);
        this.redrawSpecial(new RedrawTarget(r));
    }

    protected LayoutContext newLayoutcontext() {
        LayoutContext result = this._sharedContext.newLayoutContextInstance();
        if (this._layout_gc == null) {
            this._layout_image = new Image((Device)this.getDisplay(), 1, 1);
            this._layout_gc = new GC((Drawable)this._layout_image);
        }
        result.setFontContext((FontContext)new SWTFontContext(this._layout_gc));
        this._sharedContext.getTextRenderer().setup(result.getFontContext());
        return result;
    }

    protected RenderingContext newRenderingContext(GC gc) {
        RenderingContext result = this._sharedContext.newRenderingContextInstance();
        result.setFontContext((FontContext)new SWTFontContext(gc));
        result.setOutputDevice((OutputDevice)new SWTOutputDevice(gc));
        this._sharedContext.getTextRenderer().setup(result.getFontContext());
        return result;
    }

    protected Rectangle getInitialExtents(LayoutContext c) {
        if (!c.isPrint()) {
            Point size = this.getScreenSize();
            if (size.x == 0 && size.y == 0) {
                size.x = 1;
                size.y = 1;
            }
            return new Rectangle(size.x, size.y);
        }
        PageBox first = Layer.createPageBox((CssContext)c, (String)"first");
        return new Rectangle(0, 0, first.getContentWidth((CssContext)c), first.getContentHeight((CssContext)c));
    }

    public Point getScreenSize() {
        org.eclipse.swt.graphics.Rectangle rect = this.getClientArea();
        return new Point(rect.width, rect.height);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return this._drawnSize;
    }

    public Rectangle getFixedRectangle() {
        Point size = this.getScreenSize();
        return new Rectangle(0, 0, size.x, size.y);
    }

    public int getX() {
        return -this._origin.x;
    }

    public int getY() {
        return -this._origin.y;
    }

    private Point checkOrigin(Point pt) {
        Point size = this.getScreenSize();
        Point p = new Point(pt.x, pt.y);
        if (p.x > this._drawnSize.x - size.x) {
            p.x = this._drawnSize.x - size.x;
        }
        if (p.x < 0) {
            p.x = 0;
        }
        if (p.y > this._drawnSize.y - size.y) {
            p.y = this._drawnSize.y - size.y;
        }
        if (p.y < 0) {
            p.y = 0;
        }
        return p;
    }

    public Point getOrigin() {
        return this._origin;
    }

    public void setOrigin(Point pt) {
        Point p = this.checkOrigin(pt);
        if (p.equals((Object)this._origin)) {
            return;
        }
        this.getHorizontalBar().setSelection(p.x);
        this.getVerticalBar().setSelection(p.y);
        this.scrollTo(p);
    }

    protected void scrollTo(Point pt) {
        if (this._origin.equals((Object)pt)) {
            return;
        }
        if (this._offscreen != null) {
            this.redrawSpecial(new RedrawNewOrigin(this._origin));
        }
        Control[] children = this.getChildren();
        for (int i = 0; i < children.length; ++i) {
            Point loc = children[i].getLocation();
            loc.x += this._origin.x - pt.x;
            loc.y += this._origin.y - pt.y;
            children[i].setLocation(loc);
        }
        this._origin = pt;
        this.redraw();
    }

    protected boolean updateScrollBars() {
        Point size = this.getScreenSize();
        ScrollBar hBar = this.getHorizontalBar();
        ScrollBar vBar = this.getVerticalBar();
        boolean needRelayout = false;
        hBar.setMaximum(this._drawnSize.x);
        hBar.setThumb(Math.min(this._drawnSize.x, size.x));
        hBar.setIncrement(15);
        hBar.setPageIncrement(size.x);
        boolean visible = this._origin.x != 0 || this._drawnSize.x > size.x;
        hBar.setVisible(visible);
        size = this.getScreenSize();
        vBar.setMaximum(this._drawnSize.y);
        vBar.setThumb(Math.min(this._drawnSize.y, size.y));
        vBar.setIncrement(15);
        vBar.setPageIncrement(size.y);
        boolean bl = visible = this._origin.y != 0 || this._drawnSize.y > size.y;
        if (!this.isPrint() && vBar.isVisible() != visible) {
            needRelayout = true;
        }
        vBar.setVisible(visible);
        return needRelayout;
    }

    private static Rectangle convertRectangle(org.eclipse.swt.graphics.Rectangle rect) {
        return new Rectangle(rect.x, rect.y, rect.width, rect.height);
    }

    public void paintControl(PaintEvent e) {
        Layer root;
        if (this._doc == null) {
            e.gc.fillRectangle(this.getClientArea());
        }
        if ((root = this.getRootLayer()) == null || this._needRelayout) {
            this.doLayout();
            root = this.getRootLayer();
            if (this._offscreen != null) {
                this._offscreen.dispose();
                this._offscreen = null;
            }
        }
        this._needRelayout = false;
        if (root == null) {
            XRLog.render((Level)Level.FINE, (String)"skipping the actual painting");
        } else {
            Point size = this.getScreenSize();
            Point origin = this.checkOrigin(this._origin);
            if (!origin.equals((Object)this._origin) && this._offscreen != null) {
                if (this._hasFixedContent || this._specialRedraw != null && !(this._specialRedraw instanceof RedrawNewOrigin)) {
                    this._offscreen.dispose();
                    this._offscreen = null;
                } else if (this._specialRedraw == null) {
                    this._specialRedraw = new RedrawNewOrigin(this._origin);
                }
            }
            this._origin = origin;
            if (this._offscreen == null) {
                this._offscreen = new Image((Device)this.getDisplay(), size.x, size.y);
                GC gc = new GC((Drawable)this._offscreen);
                RenderingContext c = this.newRenderingContext(gc);
                c.getOutputDevice().setClip((Shape)new Rectangle(0, 0, size.x, size.y));
                this.doRender(c);
                gc.dispose();
            } else if (this._specialRedraw instanceof RedrawTarget) {
                org.eclipse.swt.graphics.Rectangle target = ((RedrawTarget)this._specialRedraw)._target;
                GC gc = new GC((Drawable)this._offscreen);
                RenderingContext c = this.newRenderingContext(gc);
                c.getOutputDevice().setClip((Shape)BasicRenderer.convertRectangle(target));
                this.doRender(c);
                gc.dispose();
            } else if (this._specialRedraw instanceof RedrawNewOrigin) {
                int height;
                int width;
                Point previousOrigin = ((RedrawNewOrigin)this._specialRedraw)._previousOrigin;
                Image img = new Image((Device)this.getDisplay(), size.x, size.y);
                GC gc = new GC((Drawable)img);
                gc.drawImage(this._offscreen, previousOrigin.x - this._origin.x, previousOrigin.y - this._origin.y);
                Area a = new Area();
                if (this._origin.x < previousOrigin.x) {
                    width = Math.min(size.x, previousOrigin.x - this._origin.x);
                    a.add(new Area(new Rectangle(0, 0, width, size.y)));
                } else if (this._origin.x > previousOrigin.x) {
                    width = Math.min(size.x, this._origin.x - previousOrigin.x);
                    a.add(new Area(new Rectangle(size.x - width, 0, width, size.y)));
                }
                if (this._origin.y < previousOrigin.y) {
                    height = Math.min(size.y, previousOrigin.y - this._origin.y);
                    a.add(new Area(new Rectangle(0, 0, size.x, height)));
                } else if (this._origin.y > previousOrigin.y) {
                    height = Math.min(size.y, this._origin.y - previousOrigin.y);
                    a.add(new Area(new Rectangle(0, size.y - height, size.x, height)));
                }
                RenderingContext c = this.newRenderingContext(gc);
                c.getOutputDevice().setClip((Shape)a);
                this.doRender(c);
                gc.dispose();
                this._offscreen.dispose();
                this._offscreen = img;
            } else if (this._specialRedraw instanceof RedrawNewSize) {
                Point previousSize = ((RedrawNewSize)this._specialRedraw)._previousSize;
                Image img = new Image((Device)this.getDisplay(), size.x, size.y);
                GC gc = new GC((Drawable)img);
                gc.drawImage(this._offscreen, 0, 0);
                if (size.x > previousSize.x || size.y > previousSize.y) {
                    Area a = new Area();
                    if (size.x > previousSize.x) {
                        a.add(new Area(new Rectangle(previousSize.x, 0, size.x - previousSize.x, size.y)));
                    }
                    if (size.y > previousSize.y) {
                        a.add(new Area(new Rectangle(0, previousSize.y, size.x, size.y - previousSize.y)));
                    }
                    RenderingContext c = this.newRenderingContext(gc);
                    c.getOutputDevice().setClip((Shape)a);
                    this.doRender(c);
                    gc.setClipping((org.eclipse.swt.graphics.Rectangle)null);
                }
                gc.dispose();
                this._offscreen.dispose();
                this._offscreen = img;
            }
            e.gc.drawImage(this._offscreen, 0, 0);
        }
        this._specialRedraw = null;
    }

    protected void doLayout() {
        if (this._doc == null) {
            return;
        }
        this._layout_context = this.newLayoutcontext();
        try {
            long start = System.currentTimeMillis();
            if (this._rootBox != null && this._needRelayout) {
                this._rootBox.reset(this._layout_context);
            } else {
                this._rootBox = BoxBuilder.createRootBox((LayoutContext)this._layout_context, (Document)this._doc);
            }
            this._rootBox.setContainingBlock((Box)new ViewportBox(this.getInitialExtents(this._layout_context)));
            this._rootBox.layout(this._layout_context);
            long end = System.currentTimeMillis();
            XRLog.layout((Level)Level.INFO, (String)("Layout took " + (end - start) + "ms"));
        }
        catch (Throwable e) {
            XRLog.exception((String)e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        Layer rootLayer = this._rootBox.getLayer();
        this._hasFixedContent = rootLayer.containsFixedContent();
        XRLog.layout((Level)Level.FINEST, (String)("after layout: " + this._rootBox));
        Dimension intrinsic_size = rootLayer.getPaintingDimension(this._layout_context);
        if (this._layout_context.isPrint()) {
            rootLayer.trimEmptyPages((CssContext)this._layout_context, intrinsic_size.height);
            if (rootLayer.getLastPage() != null) {
                rootLayer.assignPagePaintingPositions((CssContext)this._layout_context, 1, 10);
                this._drawnSize = new Point(rootLayer.getMaxPageWidth((CssContext)this._layout_context, 10), rootLayer.getLastPage().getPaintingBottom() + 10);
            } else {
                this._drawnSize = new Point(0, 0);
            }
        } else {
            this._drawnSize = new Point(intrinsic_size.width, intrinsic_size.height);
        }
        this._noResize = true;
        if (this.updateScrollBars()) {
            this.doLayout();
        }
        this._noResize = false;
        this.fireDocumentLoaded();
    }

    protected void doRender(RenderingContext c) {
        try {
            c.getOutputDevice().translate((double)(-this._origin.x), (double)(-this._origin.y));
            long start = System.currentTimeMillis();
            if (c.isPrint()) {
                this.paintPagedView(c, this._rootBox.getLayer());
            } else {
                this._rootBox.getLayer().paint(c);
            }
            long after = System.currentTimeMillis();
            if (Configuration.isTrue((String)"xr.incremental.repaint.print-timing", (boolean)false)) {
                Uu.p((Object)("repaint took ms: " + (after - start)));
            }
        }
        catch (Throwable e) {
            XRLog.exception((String)e.getMessage(), (Throwable)e);
        }
        ((SWTOutputDevice)c.getOutputDevice()).clean();
    }

    private void paintPagedView(RenderingContext c, Layer root) {
        if (root.getLastPage() == null) {
            return;
        }
        SWTOutputDevice out = (SWTOutputDevice)c.getOutputDevice();
        GC gc = out.getGC();
        Shape working = out.getClip();
        List pages = root.getPages();
        c.setPageCount(pages.size());
        for (int i = 0; i < pages.size(); ++i) {
            PageBox page = (PageBox)pages.get(i);
            c.setPage(i, page);
            Rectangle overall = page.getScreenPaintingBounds((CssContext)c, 10);
            --overall.x;
            --overall.y;
            ++overall.width;
            ++overall.height;
            Rectangle bounds = new Rectangle(overall);
            ++bounds.width;
            ++bounds.height;
            if (!working.intersects(bounds)) continue;
            page.paintBackground(c, 10, (short)1);
            page.paintMarginAreas(c, 10, (short)1);
            page.paintBorder(c, 10, (short)1);
            Color old = gc.getForeground();
            gc.setForeground(gc.getDevice().getSystemColor(2));
            gc.drawRectangle(overall.x, overall.y, overall.width, overall.height);
            gc.setForeground(old);
            Rectangle content = page.getPagedViewClippingBounds((CssContext)c, 10);
            out.clip(content);
            int left = 10 + page.getMarginBorderPadding((CssContext)c, 1);
            int top = page.getPaintingTop() + page.getMarginBorderPadding((CssContext)c, 3) - page.getTop();
            out.translate(left, top);
            root.paint(c);
            out.translate(-left, -top);
            out.setClip(working);
        }
        out.setClip(working);
    }

    public Document getDocument() {
        return this._doc;
    }

    public void reload() {
        if (this._doc == null) {
            return;
        }
        this._rootBox = null;
        this._active_element = null;
        this._hovered_element = null;
        this._focus_element = null;
        if (Configuration.isTrue((String)"xr.cache.stylesheets", (boolean)true)) {
            this._sharedContext.getCss().flushStyleSheets();
        } else {
            this._sharedContext.getCss().flushAllStyleSheets();
        }
        this.setCursor(null);
        this._sharedContext.reset();
        if (this._offscreen != null) {
            this._offscreen.dispose();
            this._offscreen = null;
        }
        this._origin = new Point(0, 0);
        this.getHorizontalBar().setSelection(0);
        this.getVerticalBar().setSelection(0);
        this.redraw();
    }

    public void setDocument(Document doc, String url, NamespaceHandler nsh) {
        this._rootBox = null;
        this._doc = doc;
        this._active_element = null;
        this._hovered_element = null;
        this._focus_element = null;
        if (Configuration.isTrue((String)"xr.cache.stylesheets", (boolean)true)) {
            this._sharedContext.getCss().flushStyleSheets();
        } else {
            this._sharedContext.getCss().flushAllStyleSheets();
        }
        this.setCursor(null);
        this._sharedContext.reset();
        if (this._offscreen != null) {
            this._offscreen.dispose();
            this._offscreen = null;
        }
        this._origin = new Point(0, 0);
        this.getHorizontalBar().setSelection(0);
        this.getVerticalBar().setSelection(0);
        if (doc == null) {
            this._drawnSize = new Point(1, 1);
            this.updateScrollBars();
        } else {
            this._sharedContext.setBaseURL(url);
            this._sharedContext.setNamespaceHandler(nsh);
            this._sharedContext.getCss().setDocumentContext(this._sharedContext, this._sharedContext.getNamespaceHandler(), doc, (UserInterface)this);
        }
        this.redraw();
    }

    public void setDocument(InputStream stream, String url, NamespaceHandler nsh) {
        Document dom = XMLResource.load((InputStream)stream).getDocument();
        this.setDocument(dom, url, nsh);
    }

    public void setDocumentFromString(String content, String url, NamespaceHandler nsh) {
        InputSource is = new InputSource(new BufferedReader(new StringReader(content)));
        Document dom = XMLResource.load((InputSource)is).getDocument();
        this.setDocument(dom, url, nsh);
    }

    public void setDocument(Document doc, String url) {
        this.setDocument(doc, url, (NamespaceHandler)new NoNamespaceHandler());
    }

    public void setDocument(String url) {
        this.setDocument(this.loadDocument(url), url, (NamespaceHandler)new NoNamespaceHandler());
    }

    public void setDocument(String url, NamespaceHandler nsh) {
        this.setDocument(this.loadDocument(url), url, nsh);
    }

    public void setDocument(InputStream stream, String url) {
        this.setDocument(stream, url, (NamespaceHandler)new NoNamespaceHandler());
    }

    private boolean isAnchorInCurrentDocument(String str) {
        return str.charAt(0) == '#';
    }

    private String getAnchorId(String url) {
        return url.substring(1, url.length());
    }

    protected void setDocumentRelative(String filename) {
        String id;
        Box box;
        String url = this._sharedContext.getUac().resolveURI(filename);
        if (this.isAnchorInCurrentDocument(filename) && (box = this._sharedContext.getBoxById(id = this.getAnchorId(filename))) != null) {
            Point pt;
            if (box.getStyle().isInline()) {
                pt = new Point(0, box.getAbsY());
            } else {
                RectPropertySet margin = box.getMargin((CssContext)this._layout_context);
                pt = new Point(0, box.getAbsY() + (int)margin.top());
            }
            this.setOrigin(pt);
            return;
        }
        Document dom = this.loadDocument(url);
        this.setDocument(dom, url);
    }

    protected Document loadDocument(String uri) {
        XMLResource xmlResource = this._sharedContext.getUac().getXMLResource(uri);
        if (xmlResource == null) {
            return null;
        }
        return xmlResource.getDocument();
    }

    public String getDocumentTitle() {
        if (this._doc == null) {
            return null;
        }
        NamespaceHandler nsh = this.getSharedContext().getNamespaceHandler();
        if (nsh == null) {
            return null;
        }
        return nsh.getDocumentTitle(this._doc);
    }

    public Box getRootBox() {
        return this._rootBox;
    }

    public Layer getRootLayer() {
        return this.getRootBox() == null ? null : this.getRootBox().getLayer();
    }

    public SharedContext getSharedContext() {
        return this._sharedContext;
    }

    public LayoutContext getLayoutContext() {
        return this._layout_context;
    }

    public Box find(int x, int y) {
        Layer l = this.getRootLayer();
        if (l != null) {
            return l.find((CssContext)this._layout_context, x + this._origin.x, y + this._origin.y, false);
        }
        return null;
    }

    public boolean isHover(Element e) {
        return e == this._hovered_element;
    }

    public Element getHovered_element() {
        return this._hovered_element;
    }

    public void setHovered_element(Element hovered_element) {
        this._hovered_element = hovered_element;
    }

    public boolean isActive(Element e) {
        return e == this._active_element;
    }

    public Element getActive_element() {
        return this._active_element;
    }

    public void setActive_element(Element active_element) {
        this._active_element = active_element;
    }

    public boolean isFocus(Element e) {
        return e == this._focus_element;
    }

    public Element getFocus_element() {
        return this._focus_element;
    }

    public void setFocus_element(Element focus_element) {
        this._focus_element = focus_element;
    }

    public boolean isPrint() {
        return this._sharedContext.isPrint();
    }

    public void setPrint(boolean print) {
        this._sharedContext.setPrint(print);
        this._sharedContext.setInteractive(!print);
        this._sharedContext.getReplacedElementFactory().reset();
        this.reload();
    }

    public void setFontScalingFactor(float scaling) {
        this._fontScalingFactor = scaling;
    }

    public void incrementFontSize() {
        this.scaleFont(this._fontScalingFactor);
    }

    public void resetFontSize() {
        this.getSharedContext().getTextRenderer().setFontScale(1.0f);
        this.reload();
    }

    public void decrementFontSize() {
        this.scaleFont(1.0f / this._fontScalingFactor);
    }

    private void scaleFont(float scaleBy) {
        TextRenderer tr = this.getSharedContext().getTextRenderer();
        float fs = tr.getFontScale() * scaleBy;
        if (fs < this._minFontScale || fs > this._maxFontScale) {
            return;
        }
        tr.setFontScale(fs);
        this.reload();
    }

    public float getMaxFontScale() {
        return this._maxFontScale;
    }

    public float getMinFontScale() {
        return this._minFontScale;
    }

    public void setMaxFontScale(float f) {
        this._maxFontScale = f;
    }

    public void setMinFontScale(float f) {
        this._minFontScale = f;
    }

    private class RedrawTarget
    extends SpecialRedraw {
        final org.eclipse.swt.graphics.Rectangle _target;

        RedrawTarget(org.eclipse.swt.graphics.Rectangle target) {
            this._target = target;
        }

        boolean isForFixedContent() {
            return true;
        }

        boolean ignoreFurther() {
            return false;
        }

        void redraw() {
            BasicRenderer.this.redraw(this._target.x, this._target.y, this._target.width, this._target.height, true);
        }
    }

    private class RedrawNewOrigin
    extends SpecialRedraw {
        final Point _previousOrigin;

        RedrawNewOrigin(Point previousOrigin) {
            this._previousOrigin = previousOrigin;
        }

        boolean isForFixedContent() {
            return false;
        }

        boolean ignoreFurther() {
            return true;
        }
    }

    private class RedrawNewSize
    extends SpecialRedraw {
        final Point _previousSize;

        RedrawNewSize(Point previousSize) {
            this._previousSize = previousSize;
        }

        boolean isForFixedContent() {
            return false;
        }

        boolean ignoreFurther() {
            return true;
        }
    }

    private abstract class SpecialRedraw {
        private SpecialRedraw() {
        }

        abstract boolean isForFixedContent();

        abstract boolean ignoreFurther();

        void redraw() {
            BasicRenderer.this.redraw();
        }
    }
}

