/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.simple.xhtml.swt;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Control;
import org.xhtmlrenderer.css.parser.FSColor;
import org.xhtmlrenderer.css.parser.FSRGBColor;
import org.xhtmlrenderer.css.style.CalculatedStyle;
import org.xhtmlrenderer.css.style.CssContext;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.simple.xhtml.FormControl;
import org.xhtmlrenderer.simple.xhtml.FormControlAdapter;
import org.xhtmlrenderer.simple.xhtml.FormControlListener;
import org.xhtmlrenderer.simple.xhtml.swt.SWTFormControl;
import org.xhtmlrenderer.swt.BasicRenderer;
import org.xhtmlrenderer.swt.SWTFSFont;

public abstract class SWTXhtmlControl
implements SWTFormControl {
    private FormControl _control;
    protected Control _swtControl;
    private Color _foreground;
    private Color _background;

    public SWTXhtmlControl(FormControl control, BasicRenderer parent, LayoutContext c, CalculatedStyle style, UserAgentCallback uac) {
        String title;
        this._control = control;
        this._swtControl = this.createSWTControl(control, parent, c, style, uac);
        this._swtControl.setFont(((SWTFSFont)style.getFSFont((CssContext)c)).getSWTFont());
        if (style.getColor() != null) {
            this._foreground = SWTXhtmlControl.createFromAWT((Device)parent.getDisplay(), style.getColor());
            this._swtControl.setForeground(this._foreground);
        }
        if (style.getBackgroundColor() != null) {
            this._background = SWTXhtmlControl.createFromAWT((Device)parent.getDisplay(), style.getBackgroundColor());
            this._swtControl.setBackground(this._background);
        }
        if (!control.isEnabled()) {
            this._swtControl.setEnabled(false);
        }
        if ((title = control.getElement().getAttribute("title")).length() != 0) {
            this._swtControl.setToolTipText(title);
        }
        control.addFormControlListener((FormControlListener)new FormControlAdapter(){

            public void enabled(FormControl control) {
                SWTXhtmlControl.this._swtControl.setEnabled(control.isEnabled());
            }
        });
    }

    private static Color createFromAWT(Device device, FSColor fsColor) {
        if (fsColor instanceof FSRGBColor) {
            FSRGBColor fsrgbcolor = (FSRGBColor)fsColor;
            return new Color(device, fsrgbcolor.getRed(), fsrgbcolor.getGreen(), fsrgbcolor.getBlue());
        }
        throw new IllegalArgumentException("Don't currently support CMYK in SWT rendering");
    }

    protected abstract Control createSWTControl(FormControl var1, BasicRenderer var2, LayoutContext var3, CalculatedStyle var4, UserAgentCallback var5);

    public void dispose() {
        this._swtControl.dispose();
        if (this._foreground != null) {
            this._foreground.dispose();
        }
        if (this._background != null) {
            this._background.dispose();
        }
    }

    public Control getSWTControl() {
        return this._swtControl;
    }

    public FormControl getFormControl() {
        return this._control;
    }
}

