/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.xhtmlrenderer.pdf.ITextRenderer;

public class PDFRenderToMultiplePages {
    public static void main(String[] args) throws IOException {
        String[] inputs = new String[]{PDFRenderToMultiplePages.newPageHtml(1, "red"), PDFRenderToMultiplePages.newPageHtml(2, "blue"), PDFRenderToMultiplePages.newPageHtml(3, "green")};
        File outputFile = File.createTempFile("FlyingSaucer.PDFRenderToMultiplePages", ".pdf");
        try (OutputStream os = Files.newOutputStream(outputFile.toPath(), new OpenOption[0]);){
            ITextRenderer renderer = new ITextRenderer();
            renderer.setDocumentFromString(inputs[0]);
            renderer.layout();
            renderer.createPDF(os, false);
            for (int i = 1; i < inputs.length; ++i) {
                renderer.setDocumentFromString(inputs[i]);
                renderer.layout();
                renderer.writeNextDocument();
            }
            renderer.finishPDF();
            System.out.println("Sample file with " + inputs.length + " documents rendered as PDF to " + outputFile);
        }
    }

    private static String newPageHtml(int pageNo, String color) {
        return "<html style='color: " + color + "' >    Page" + pageNo + "</html>";
    }
}

