/*
 * Decompiled with CFR 0.152.
 */
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.xhtmlrenderer.simple.Graphics2DRenderer;
import org.xhtmlrenderer.swing.Java2DRenderer;
import org.xhtmlrenderer.util.FSImageWriter;

public class ImageRender {
    public static void main(String[] args) throws IOException {
        String url;
        if (args.length != 1) {
            ImageRender.usage("Incorrect argument list.");
        }
        if (!(url = args[0]).contains("://")) {
            File f = new File(url);
            if (f.exists()) {
                Java2DRenderer renderer = new Java2DRenderer(f, 1024);
                renderer.setBufferedImageType(1);
                BufferedImage image = renderer.getImage();
                FSImageWriter imageWriter = new FSImageWriter();
                String path = f.getAbsolutePath();
                path = path.substring(0, path.lastIndexOf("."));
                imageWriter.write(image, path + ".png");
                BufferedImage img = Graphics2DRenderer.renderToImageAutoSize((String)f.toURI().toURL().toExternalForm(), (int)1024, (int)2);
                ImageIO.write((RenderedImage)img, "png", new File(path + "-G2DR.png"));
            } else {
                ImageRender.usage("File to render is not found: " + url);
            }
        }
    }

    private static void usage(String err) {
        if (err != null && !err.isEmpty()) {
            System.err.println("==>" + err);
        }
        System.err.println("Usage: ... [url]");
        System.exit(1);
    }
}

