/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.demo.aboutbox;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import org.xhtmlrenderer.demo.aboutbox.DemoMarker;
import org.xhtmlrenderer.demo.aboutbox.DemoUserAgent;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.simple.XHTMLPanel;
import org.xhtmlrenderer.util.Uu;

public final class AboutBox
extends JDialog
implements Runnable {
    private static final long serialVersionUID = 1L;
    private final JScrollPane scroll;
    private boolean go;

    public AboutBox(String text, String url) {
        Uu.p((Object)"starting the about box");
        this.setTitle(text);
        XHTMLPanel panel = new XHTMLPanel((UserAgentCallback)new DemoUserAgent());
        int w = 400;
        int h = 500;
        panel.setPreferredSize(new Dimension(w, h));
        this.scroll = new JScrollPane((Component)panel);
        this.scroll.setVerticalScrollBarPolicy(22);
        this.scroll.setHorizontalScrollBarPolicy(31);
        this.scroll.setPreferredSize(new Dimension(w, h));
        this.getContentPane().add((Component)this.scroll, "Center");
        JButton close_button = new JButton("Close");
        this.getContentPane().add((Component)close_button, "South");
        close_button.addActionListener(evt -> {
            this.setVisible(false);
            this.go = false;
        });
        try {
            this.loadPage(url, panel);
        }
        catch (Exception ex) {
            Uu.p((Object)ex);
        }
        this.pack();
        this.setSize(w, h);
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screen.width - w) / 2, (screen.height - h) / 2);
    }

    public void loadPage(String url_text, XHTMLPanel panel) throws MalformedURLException {
        URL ref = null;
        if (url_text.startsWith("demo:")) {
            Uu.p((Object)"starts with demo");
            DemoMarker marker = new DemoMarker();
            Uu.p((Object)("url text = " + url_text));
            String short_url = url_text.substring(5);
            if (!short_url.startsWith("/")) {
                short_url = "/" + short_url;
            }
            Uu.p((Object)("short url = " + short_url));
            ref = marker.getClass().getResource(short_url);
            Uu.p((Object)("ref = " + ref));
            panel.setDocument(ref.toExternalForm());
        } else if (url_text.startsWith("http")) {
            panel.setDocument(url_text);
        } else {
            ref = new File(url_text).toURI().toURL();
            panel.setDocument(ref.toExternalForm());
        }
        Uu.p((Object)("ref = " + ref));
        Uu.p((Object)("url_text = " + url_text));
    }

    public void startScrolling() {
        this.go = true;
        new Thread(this).start();
    }

    @Override
    public void run() {
        while (this.go) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception ex) {
                Uu.p((Object)ex);
            }
            JScrollBar sb = this.scroll.getVerticalScrollBar();
            sb.setValue(sb.getValue() + 1);
        }
    }

    @Override
    public void setVisible(boolean vis) {
        super.setVisible(vis);
        if (vis) {
            this.startScrolling();
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("About Box Test");
        frame.setDefaultCloseOperation(3);
        JButton launch = new JButton("Show About Box");
        frame.getContentPane().add(launch);
        frame.pack();
        frame.setVisible(true);
        launch.addActionListener(evt -> {
            AboutBox ab = new AboutBox("About Flying Saucer", "demo:demos/index.xhtml");
            ab.setVisible(true);
        });
    }
}

