/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xhtmlrenderer.extend.NamespaceHandler;
import org.xhtmlrenderer.simple.FSScrollPane;
import org.xhtmlrenderer.simple.XHTMLPanel;
import org.xhtmlrenderer.simple.extend.XhtmlNamespaceHandler;

public class AddNodeToDocument {
    private JFrame frame;
    private XHTMLPanel panel;
    private Document domDocument;
    private Element documentRoot;

    public static void main(String[] args) {
        new AddNodeToDocument().run();
    }

    private void run() {
        SwingUtilities.invokeLater(() -> {
            this.initFrame();
            this.initPanel();
            AbstractAction addDocAction = new AbstractAction("Add Node"){

                @Override
                public void actionPerformed(ActionEvent event) {
                    AddNodeToDocument.this.documentRoot.appendChild(AddNodeToDocument.this.domDocument.createTextNode("adding node at " + new Date()));
                    AddNodeToDocument.this.documentRoot.appendChild(AddNodeToDocument.this.domDocument.createElement("br"));
                    AddNodeToDocument.this.panel.setDocument(AddNodeToDocument.this.domDocument);
                }
            };
            JButton btn = new JButton(addDocAction);
            this.frame.getContentPane().add("South", btn);
            this.frame.pack();
            this.frame.setSize(1024, 768);
            this.frame.setVisible(true);
        });
    }

    private void initPanel() {
        this.panel = new XHTMLPanel();
        try {
            this.panel.setDocumentFromString("<html style='position: absolute;'>This line was in the original document. Press the button to add a new node to the same document <br /></html>", null, (NamespaceHandler)new XhtmlNamespaceHandler());
            this.domDocument = this.panel.getDocument();
            this.documentRoot = this.domDocument.getDocumentElement();
        }
        catch (Exception e) {
            this.messageAndExit("Could not render page: " + e.getMessage(), -1);
        }
        FSScrollPane fsScrollPane = new FSScrollPane((JPanel)this.panel);
        this.frame.getContentPane().add("Center", (Component)fsScrollPane);
    }

    private void initFrame() {
        this.frame = new JFrame("XHTMLPanel");
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.frame.setDefaultCloseOperation(3);
    }

    private void messageAndExit(String msg, int rtnCode) {
        System.out.println(msg);
        System.exit(rtnCode);
    }
}

