/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.FlowLayout;
import java.io.File;
import java.net.MalformedURLException;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.xhtmlrenderer.simple.FSScrollPane;
import org.xhtmlrenderer.simple.XHTMLPanel;

public class FontScaleJPanelRender {
    private String fileName;

    public static void main(String[] args) {
        try {
            new FontScaleJPanelRender().run(args);
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
        }
    }

    private void run(String[] args) {
        this.loadAndCheckArgs(args);
        XHTMLPanel panel = new XHTMLPanel();
        try {
            panel.setDocument(new File(this.fileName));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        FSScrollPane scroll = new FSScrollPane((JPanel)panel);
        JFrame frame = new JFrame("Flying Saucer: " + panel.getDocumentTitle());
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add("Center", (Component)scroll);
        panel.setFontScalingFactor(1.15f);
        panel.setMinFontScale(0.01f);
        panel.setMaxFontScale(12.0f);
        JButton smaller = new JButton("F-");
        smaller.addActionListener(event -> {
            panel.decrementFontSize();
            System.out.println("decremented");
        });
        JButton def = new JButton("F0");
        def.addActionListener(event -> {
            panel.resetFontSize();
            System.out.println("reset");
        });
        JButton larger = new JButton("F+");
        larger.addActionListener(event -> {
            panel.incrementFontSize();
            System.out.println("incremented");
        });
        JPanel top = new JPanel(new FlowLayout());
        top.add(smaller);
        top.add(def);
        top.add(larger);
        frame.getContentPane().add("North", top);
        frame.pack();
        frame.setSize(1024, 768);
        frame.setVisible(true);
    }

    private void loadAndCheckArgs(String[] args) {
        if (args.length == 0) {
            throw new IllegalArgumentException("Enter a file or URI.");
        }
        String name = args[0];
        if (!new File(name).exists()) {
            throw new IllegalArgumentException("File " + name + " does not exist.");
        }
        this.fileName = name;
    }
}

