/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.demo.browser;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.xhtmlrenderer.demo.browser.DemoMarker;
import org.xhtmlrenderer.demo.browser.DirectoryLister;
import org.xhtmlrenderer.demo.browser.PlainTextXMLReader;
import org.xhtmlrenderer.resource.XMLResource;
import org.xhtmlrenderer.swing.DelegatingUserAgent;
import org.xhtmlrenderer.util.GeneralUtil;
import org.xhtmlrenderer.util.Uu;
import org.xhtmlrenderer.util.XRLog;
import org.xml.sax.InputSource;

public class PanelManager
extends DelegatingUserAgent {
    private int index = -1;
    private final List<String> history = new ArrayList<String>();

    @Nullable
    @CheckReturnValue
    public String resolveURI(@Nullable String uri) {
        String burl = this.getBaseURL();
        URL ref = null;
        if (uri == null) {
            return burl;
        }
        if (uri.trim().isEmpty()) {
            return burl;
        }
        if (uri.startsWith("demo:")) {
            DemoMarker marker = new DemoMarker();
            String short_url = uri.substring(5);
            if (!short_url.startsWith("/")) {
                short_url = "/" + short_url;
            }
            ref = marker.getClass().getResource(short_url);
            Uu.p((Object)("ref = " + ref));
        } else if (uri.startsWith("demoNav:")) {
            DemoMarker marker = new DemoMarker();
            String short_url = uri.substring("demoNav:".length());
            if (!short_url.startsWith("/")) {
                short_url = "/" + short_url;
            }
            ref = marker.getClass().getResource(short_url);
            Uu.p((Object)("Demo navigation URI, ref = " + ref));
        } else if (uri.startsWith("javascript")) {
            Uu.p((Object)("Javascript URI, ignoring: " + uri));
        } else if (uri.startsWith("news")) {
            Uu.p((Object)("News URI, ignoring: " + uri));
        } else {
            try {
                URL base = burl == null || burl.length() == 0 ? new File(".").toURL() : new URL(burl);
                ref = new URL(base, uri);
            }
            catch (MalformedURLException e) {
                Uu.p((Object)("URI/URL is malformed: " + burl + " or " + uri));
            }
        }
        if (ref == null) {
            return null;
        }
        return ref.toExternalForm();
    }

    public XMLResource getXMLResource(String uri) {
        XMLResource xr;
        block34: {
            if ((uri = this.resolveURI(uri)) != null && uri.startsWith("file:")) {
                File file;
                try {
                    StringBuilder sbURI = GeneralUtil.htmlEscapeSpace((String)uri);
                    XRLog.general((String)("Encoded URI: " + sbURI));
                    file = new File(new URI(sbURI.toString()));
                }
                catch (URISyntaxException e) {
                    XRLog.exception((String)("Invalid file URI " + uri), (Throwable)e);
                    return this.getNotFoundDocument(uri);
                }
                if (file.isDirectory()) {
                    String dirList = DirectoryLister.list(file);
                    return XMLResource.load((Reader)new StringReader(dirList));
                }
            }
            xr = null;
            try {
                URLConnection uc = new URL(uri).openConnection();
                uc.connect();
                String contentType = uc.getContentType();
                if (contentType.equals("text/plain") || contentType.equals("content/unknown")) {
                    try (InputStream inputStream = uc.getInputStream();){
                        SAXSource source = new SAXSource(new PlainTextXMLReader(inputStream), new InputSource());
                        xr = XMLResource.load((Source)source);
                        break block34;
                    }
                }
                if (contentType.startsWith("image")) {
                    String doc = "<img src='" + uri + "'/>";
                    xr = XMLResource.load((Reader)new StringReader(doc));
                    break block34;
                }
                try (InputStream inputStream = uc.getInputStream();){
                    xr = XMLResource.load((InputStream)inputStream);
                }
            }
            catch (MalformedURLException e) {
                XRLog.exception((String)("bad URL given: " + uri), (Throwable)e);
            }
            catch (IOException e) {
                XRLog.exception((String)("IO problem for " + uri), (Throwable)e);
            }
        }
        if (xr == null) {
            xr = this.getNotFoundDocument(uri);
        }
        return xr;
    }

    private XMLResource getNotFoundDocument(String uri) {
        String cleanUri = GeneralUtil.escapeHTML((String)uri);
        String notFound = "<html><h1>Document not found</h1><p>Could not access URI <pre>" + cleanUri + "</pre></p></html>";
        XMLResource xr = XMLResource.load((Reader)new StringReader(notFound));
        return xr;
    }

    public boolean isVisited(String uri) {
        if (uri == null) {
            return false;
        }
        uri = this.resolveURI(uri);
        return this.history.contains(uri);
    }

    public void setBaseURL(String url) {
        String historic;
        String burl = this.resolveURI(url);
        if (burl == null) {
            burl = "error:FileNotFound";
        }
        super.setBaseURL(burl);
        if (this.index >= 0 && (historic = this.history.get(this.index)).equals(burl)) {
            return;
        }
        ++this.index;
        int i = this.index;
        while (i < this.history.size()) {
            this.history.remove(i);
        }
        this.history.add(this.index, burl);
    }

    public String getForward() {
        ++this.index;
        return this.history.get(this.index);
    }

    public String getBack() {
        --this.index;
        return this.history.get(this.index);
    }

    public boolean hasForward() {
        return this.index + 1 < this.history.size() && this.index >= 0;
    }

    public boolean hasBack() {
        return this.index > 0;
    }
}

