/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.MalformedURLException;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.xhtmlrenderer.extend.ReplacedElementFactory;
import org.xhtmlrenderer.simple.FSScrollPane;
import org.xhtmlrenderer.simple.XHTMLPanel;
import org.xhtmlrenderer.test.DelegatingReplacedElementFactory;
import org.xhtmlrenderer.test.ElementReplacer;
import org.xhtmlrenderer.test.SwingImageReplacer;

public class ReplaceRender {
    private String fileName;

    public static void main(String[] args) {
        try {
            new ReplaceRender().run(args);
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
        }
    }

    private void run(String[] args) {
        this.loadAndCheckArgs(args);
        final XHTMLPanel panel = this.setupPanel();
        try {
            panel.setDocument(new File(this.fileName));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        FSScrollPane scroll = new FSScrollPane((JPanel)panel);
        JFrame frame = new JFrame("Flying Saucer: " + panel.getDocumentTitle());
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add((Component)scroll, "Center");
        frame.getContentPane().add((Component)new JButton(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                System.out.println("\n\n\nRELOAD\n\n\n");
                panel.setDocument(panel.getDocument(), panel.getSharedContext().getBaseURL());
            }
        }), "North");
        frame.pack();
        frame.setSize(1024, 768);
        frame.setVisible(true);
    }

    private XHTMLPanel setupPanel() {
        XHTMLPanel panel = new XHTMLPanel();
        DelegatingReplacedElementFactory delegatingFactory = new DelegatingReplacedElementFactory();
        delegatingFactory.addReplacer((ElementReplacer)new SwingImageReplacer());
        panel.getSharedContext().setReplacedElementFactory((ReplacedElementFactory)delegatingFactory);
        return panel;
    }

    private void loadAndCheckArgs(String[] args) {
        if (args.length == 0) {
            throw new IllegalArgumentException("Enter a file or URI.");
        }
        String name = args[0];
        if (!new File(name).exists()) {
            throw new IllegalArgumentException("File " + name + " does not exist.");
        }
        this.fileName = name;
    }
}

