/*
 * Decompiled with CFR 0.152.
 */
import com.lowagie.text.DocumentException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.w3c.dom.Document;
import org.xhtmlrenderer.event.DefaultDocumentListener;
import org.xhtmlrenderer.event.DocumentListener;
import org.xhtmlrenderer.extend.NamespaceHandler;
import org.xhtmlrenderer.pdf.ITextFontResolver;
import org.xhtmlrenderer.pdf.ITextRenderer;
import org.xhtmlrenderer.resource.FSEntityResolver;
import org.xhtmlrenderer.resource.XMLResource;
import org.xhtmlrenderer.simple.FSScrollPane;
import org.xhtmlrenderer.simple.XHTMLPanel;
import org.xhtmlrenderer.simple.extend.XhtmlNamespaceHandler;
import org.xhtmlrenderer.swing.FSMouseListener;
import org.xhtmlrenderer.swing.LinkListener;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.XMLReaderFactory;

public class FontGlyphTableRender {
    private static final int TO_SWING = 1;
    private static final int TO_PDF = 2;
    private static final String OUTPUT_ENTITIES = "entities";
    private static final String OUTPUT_CODEPOINTS = "codepoints";
    private static final int ENT_PER_PAGE = 399;
    private int curFrom;
    private String outputType = "codepoints";
    private Font currentFont;
    private JFrame frame;
    private XHTMLPanel xpanel;
    private JTextField fontPathTF;
    private JTextField familyNameFieldAwt;
    private JTextField familyNameFieldIText;
    private JButton prevBtn;
    private JButton nextBtn;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> new FontGlyphTableRender().run());
    }

    private void run() {
        this.frame = new JFrame("Flying Saucer: Show Font Glyphs");
        this.frame.setDefaultCloseOperation(3);
        JPanel optionsPanel = new JPanel(new BorderLayout());
        this.fontPathTF = new JTextField();
        this.fontPathTF.setColumns(40);
        this.familyNameFieldAwt = new JTextField();
        this.familyNameFieldAwt.setEnabled(true);
        this.familyNameFieldAwt.setEditable(false);
        this.familyNameFieldAwt.setColumns(20);
        this.familyNameFieldIText = new JTextField();
        this.familyNameFieldIText.setEnabled(true);
        this.familyNameFieldIText.setEditable(false);
        this.familyNameFieldIText.setColumns(20);
        JPanel top1 = new JPanel(new FlowLayout(0));
        top1.add(new JLabel("Enter font path: "));
        top1.add(this.fontPathTF);
        JButton chooseFontFileBtn = new JButton("...");
        chooseFontFileBtn.addActionListener(e -> {
            String filename = File.separator + "tmp";
            String famPath = this.fontPathTF.getText();
            if (this.currentFont != null && famPath.length() > 0) {
                filename = new File(famPath).getParent();
            }
            JFileChooser fc = new JFileChooser(new File(filename));
            fc.showOpenDialog(this.frame);
            File selFile = fc.getSelectedFile();
            Font font = null;
            String msg = "";
            try {
                font = this.loadFont(selFile.getPath());
            }
            catch (IOException e1) {
                msg = e1.getMessage();
            }
            if (font == null) {
                JOptionPane.showMessageDialog(this.frame, "Can't load file--is it a valid Font file? " + msg);
            } else {
                this.fontPathTF.setText(selFile.getPath());
                this.familyNameFieldAwt.setText(font.getFamily());
                this.familyNameFieldIText.setText(this.getITextFontFamilyName(selFile));
            }
        });
        top1.add(chooseFontFileBtn);
        ActionListener outputSelection = e -> {
            this.outputType = e.getActionCommand();
            this.enableButtons();
            if (this.currentFont != null) {
                this.deferredChangePage(this.curFrom);
            }
        };
        JRadioButton jrbCodePoint = new JRadioButton("Codepoints");
        jrbCodePoint.setActionCommand(OUTPUT_CODEPOINTS);
        jrbCodePoint.addActionListener(outputSelection);
        jrbCodePoint.setSelected(true);
        JRadioButton jrbEntities = new JRadioButton("Entities");
        jrbEntities.setActionCommand(OUTPUT_ENTITIES);
        jrbEntities.addActionListener(outputSelection);
        ButtonGroup bg = new ButtonGroup();
        bg.add(jrbCodePoint);
        bg.add(jrbEntities);
        top1.add(jrbCodePoint);
        top1.add(jrbEntities);
        JPanel top2 = new JPanel(new FlowLayout(0));
        top2.add(new JLabel("Family (AWT): "));
        top2.add(this.familyNameFieldAwt);
        top2.add(new JLabel("Family (iText): "));
        top2.add(this.familyNameFieldIText);
        JPanel top = new JPanel(new BorderLayout());
        top.add((Component)top1, "North");
        top.add((Component)top2, "Center");
        JPanel mid = new JPanel(new FlowLayout(0));
        this.prevBtn = new JButton("Prev");
        this.nextBtn = new JButton("Next");
        JButton pdfBtn = new JButton("PDF");
        JButton renderBtn = new JButton("Render");
        this.prevBtn.addActionListener(actionEvent -> this.deferredChangePage(this.curFrom - 399));
        this.nextBtn.addActionListener(actionEvent -> this.deferredChangePage(this.curFrom + 399));
        renderBtn.addActionListener(actionEvent -> this.deferredChangePage(this.curFrom));
        pdfBtn.addActionListener(actionEvent -> {
            this.resolveCurrentFont();
            if (this.currentFont == null) {
                JOptionPane.showMessageDialog(this.frame, "Need a valid font file path");
                this.fontPathTF.requestFocus();
                return;
            }
            this.deferredLoadAndRender(this.curFrom, 2);
        });
        mid.add(this.prevBtn);
        mid.add(this.nextBtn);
        mid.add(renderBtn);
        mid.add(pdfBtn);
        optionsPanel.add((Component)top, "North");
        optionsPanel.add((Component)mid, "Center");
        this.fontPathTF.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FontGlyphTableRender.this.deferredChangePage(FontGlyphTableRender.this.curFrom);
            }
        });
        this.xpanel = new XHTMLPanel();
        this.xpanel.addDocumentListener((DocumentListener)new DefaultDocumentListener(){

            public void documentLoaded() {
                FontGlyphTableRender.this.frame.setCursor(Cursor.getDefaultCursor());
            }
        });
        this.resetMouseListeners();
        FSScrollPane scroll = new FSScrollPane((JPanel)this.xpanel);
        scroll.setVerticalScrollBarPolicy(20);
        scroll.setHorizontalScrollBarPolicy(30);
        JPanel cont = new JPanel(new BorderLayout());
        cont.add((Component)optionsPanel, "North");
        cont.add((Component)scroll, "Center");
        this.frame.getContentPane().add(cont);
        this.frame.pack();
        this.frame.setSize(1024, 730);
        this.enableButtons();
        this.frame.setVisible(true);
    }

    private String getITextFontFamilyName(File selFile) {
        Set set = ITextFontResolver.getDistinctFontFamilyNames((String)selFile.getPath(), (String)"Identity-H", (boolean)true);
        System.out.println("All family names reported by iText for " + selFile.getPath() + ": " + set);
        return (String)set.iterator().next();
    }

    private void resetMouseListeners() {
        List l = this.xpanel.getMouseTrackingListeners();
        for (FSMouseListener listener : l) {
            if (!(listener instanceof LinkListener)) continue;
            this.xpanel.removeMouseTrackingListener(listener);
        }
    }

    private void enableButtons() {
        this.prevBtn.setEnabled(this.outputType.equals(OUTPUT_CODEPOINTS) && this.curFrom > 0);
        this.nextBtn.setEnabled(this.outputType.equals(OUTPUT_CODEPOINTS) && Math.pow(2.0, 16.0) - (double)this.curFrom != 0.0);
    }

    private Font loadFont(String fontPath) throws IOException {
        try {
            Font font = Font.createFont(0, new File(fontPath).toURL().openStream());
            return font.deriveFont(0, 12.0f);
        }
        catch (FontFormatException e) {
            System.err.println(fontPath + " INVALID FONT FORMAT " + e.getMessage());
            return null;
        }
    }

    private void deferredChangePage(int startAt) {
        this.deferredLoadAndRender(startAt, 1);
    }

    private void deferredLoadAndRender(int startAt, int renderTo) {
        this.resolveCurrentFont();
        if (this.currentFont == null) {
            JOptionPane.showMessageDialog(this.frame, "Can't load font--check font file path.");
            this.fontPathTF.requestFocus();
            return;
        }
        this.frame.setCursor(Cursor.getPredefinedCursor(3));
        new Thread(() -> {
            Document doc = this.loadDocument(startAt, renderTo);
            if (renderTo == 1) {
                SwingUtilities.invokeLater(() -> {
                    try {
                        this.curFrom = startAt;
                        this.xpanel.setDocument(doc, null, (NamespaceHandler)new XhtmlNamespaceHandler());
                        this.xpanel.getSharedContext().getCss().getCascadedStyle(null, false);
                    }
                    catch (Throwable e) {
                        JOptionPane.showMessageDialog(this.frame, "Can't load document (table of glyphs). Err: " + e.getMessage());
                    }
                    this.enableButtons();
                });
            } else {
                this.frame.setCursor(Cursor.getDefaultCursor());
                this.renderPDF(doc);
            }
        }).start();
    }

    private Document loadDocument(int startAt, int renderTo) {
        String page;
        this.curFrom = startAt;
        String fontFamily = this.getFontFamily(renderTo);
        if (this.outputType.equals(OUTPUT_CODEPOINTS)) {
            Table table = this.buildGlyphTable(startAt, startAt + 399);
            page = new Page().toHtml(table.toHtml(fontFamily, this.curFrom), fontFamily);
        } else {
            page = this.parseEnt(new Page().toHtml("", fontFamily));
        }
        InputSource is = new InputSource(new BufferedReader(new StringReader(page)));
        return XMLResource.load((InputSource)is).getDocument();
    }

    private Table buildGlyphTable(int from, int to) {
        Table table = new Table(16);
        for (int j = from; j <= to; ++j) {
            if (this.isLegalInXml(j)) {
                if (this.currentFont.canDisplay((char)j)) {
                    table.addColumn("&amp;#" + j + ";");
                    table.addGlyph("&#" + j + ";");
                    continue;
                }
                table.addColumn("&amp;#" + j + ";");
                table.addGlyph("&nbsp;");
                continue;
            }
            table.addColumn("&amp;#" + j + ";");
            table.addGlyph("!");
        }
        return table;
    }

    private void renderPDF(Document doc) {
        String msgToUser;
        File f;
        try {
            f = File.createTempFile("flying-saucer-glyph-test", ".pdf");
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.frame, "Can't create temp file for PDF output, err: " + e.getMessage());
            return;
        }
        ITextRenderer renderer = new ITextRenderer();
        try (FileOutputStream fos = new FileOutputStream(f);){
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            renderer.setDocument(doc, null, (NamespaceHandler)new XhtmlNamespaceHandler());
            ITextFontResolver resolver = renderer.getFontResolver();
            resolver.addFont(this.fontPathTF.getText(), "Identity-H", true);
            renderer.layout();
            renderer.createPDF((OutputStream)bos);
            msgToUser = "Rendered PDF: " + f.getCanonicalPath();
        }
        catch (DocumentException | IOException e) {
            msgToUser = "Can't create PDF, err: " + e.getMessage();
        }
        String finalMsg = msgToUser;
        SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(this.frame, finalMsg));
    }

    private void resolveCurrentFont() {
        String path = this.fontPathTF.getText();
        if (path.length() == 0) {
            this.currentFont = null;
            return;
        }
        try {
            this.currentFont = this.loadFont(path);
            if (this.currentFont != null) {
                this.familyNameFieldAwt.setText(this.currentFont.getFamily());
                this.familyNameFieldIText.setText(this.getITextFontFamilyName(new File(this.fontPathTF.getText())));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.currentFont = null;
        }
    }

    private String parseEnt(String html) {
        try {
            final Table table = new Table(15);
            XMLReader parser = XMLReaderFactory.createXMLReader();
            InputSource is = new InputSource(new BufferedReader(new StringReader(html)));
            try {
                parser.setFeature("http://xml.org/sax/features/validation", true);
            }
            catch (SAXException e) {
                System.err.println("Cannot activate validation.");
            }
            parser.setEntityResolver((EntityResolver)FSEntityResolver.instance());
            DefaultHandler2 dh2 = new DefaultHandler2(){
                boolean isEnt;

                @Override
                public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
                    super.externalEntityDecl(name, publicId, systemId);
                    this.isEnt = systemId.endsWith(".ent");
                }

                @Override
                public void internalEntityDecl(String name, String value) throws SAXException {
                    super.internalEntityDecl(name, value);
                    if (this.isEnt) {
                        if (name.startsWith("%")) {
                            return;
                        }
                        char codePoint = value.charAt(0);
                        table.addColumn("&amp;" + name + ";");
                        table.addColumn("&amp;#" + codePoint + ";");
                        table.addGlyph("&#" + codePoint + ";");
                    }
                }
            };
            parser.setProperty("http://xml.org/sax/properties/declaration-handler", dh2);
            parser.parse(is);
            return new Page().toHtml(table.toHtml(this.getFontFamily(1), 0), this.getFontFamily(1));
        }
        catch (IOException | SAXException e) {
            e.printStackTrace();
            return "";
        }
    }

    private boolean isLegalInXml(int uccp) {
        return (uccp == 9 || uccp == 10 || uccp == 13 || uccp >= 32 && uccp <= 55295 || uccp >= 57344 && uccp <= 65533 || uccp >= 65536 && uccp <= 0x10FFFF) && uccp != 3549;
    }

    private String getFontFamily(int renderTo) {
        if (renderTo == 1) {
            return this.currentFont.getFamily();
        }
        return this.getITextFontFamilyName(new File(this.fontPathTF.getText()));
    }

    private static class Table {
        private final int colCnt;
        private final List<Col> cols = new ArrayList<Col>();
        private final List<String> headerLines = new ArrayList<String>();

        private Table(int colCnt) {
            this.colCnt = colCnt;
        }

        public String toHtml(String fontFamily, int curFrom) {
            StringBuilder sb = new StringBuilder();
            for (String line : this.headerLines) {
                sb.append("<p>").append(line).append("</p>\n");
            }
            sb.append("<p>Table of Unicode Characters</p>\n");
            sb.append("<p>Using font: ").append(fontFamily).append(", Unicode code points starting with ").append(curFrom).append("</p>\n");
            sb.append("<p>Empty cell means no glyph available; ! means codepoint not allowed in XML, per spec.</p>\n");
            sb.append("<table>\n");
            for (int i = 0; i < this.colCnt; ++i) {
                sb.append("<col class=\"").append(this.cols.get(i).cssClass).append("\"/>\n");
            }
            sb.append("<tr>\n");
            int cnt = 0;
            Iterator<Col> it = this.cols.iterator();
            while (it.hasNext()) {
                Col col = it.next();
                sb.append("<td class=\"").append(this.cols.get(cnt).cssClass).append("\">").append(col.content).append("</td>");
                if (++cnt % this.colCnt != 0 || !it.hasNext()) continue;
                sb.append("\n</tr>\n");
                sb.append("<tr>\n");
            }
            sb.append("\n</tr>\n");
            sb.append("</table>\n");
            return sb.toString();
        }

        public void addColumn(String content) {
            this.cols.add(new Col("", content));
        }

        public void addGlyph(String content) {
            this.cols.add(new Col("glyph", content));
        }

        public void addHeaderLine(String text) {
            this.headerLines.add(text);
        }

        static class Col {
            private final String cssClass;
            private final String content;

            Col(String cssClass, String content) {
                this.cssClass = cssClass;
                this.content = content;
            }
        }
    }

    private static class Page {
        private Page() {
        }

        public String toHtml(String bodyContent, String fontFamily) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getHeadDecl(this.getStyleDecl(fontFamily)));
            sb.append("<body>\n");
            sb.append(bodyContent);
            sb.append("</body>\n");
            sb.append("</html>\n");
            return sb.toString();
        }

        private String getHeadDecl(String style) {
            return "<?xml version='1.0' encoding='utf-8'?>\n<!DOCTYPE html PUBLIC '-//W3C//DTD XHTML 1.0 Strict//EN' 'http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd'>\n<html xmlns='http://www.w3.org/1999/xhtml'>\n<head><title>Full Entity Chart</title>\n" + style + "</head>\n";
        }

        private String getStyleDecl(String fontFamily) {
            String css = "* {font-size: 8pt; font-family: \"" + fontFamily + "\" } table {table-layout: fixed; width: 100%; border-collapse: collapse; border: 1px solid black;} col {} .glyph {width: 1.35em; border-right-width: 2px;} td {border: 1px solid black; }td .glyph {}";
            return "<style type=\"text/css\" media=\"all\">\n" + css + "\n</style>\n";
        }
    }
}

