/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.demo.aboutbox;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.xhtmlrenderer.demo.aboutbox.DemoMarker;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.resource.CSSResource;
import org.xhtmlrenderer.resource.ImageResource;
import org.xhtmlrenderer.resource.XMLResource;
import org.xhtmlrenderer.swing.AWTFSImage;
import org.xhtmlrenderer.util.Uu;
import org.xhtmlrenderer.util.XRLog;

public class DemoUserAgent
implements UserAgentCallback {
    private String baseUrl;
    private int index = -1;
    private final List<String> history = new ArrayList<String>();
    private final int imageCacheCapacity = 16;
    private final Map<String, ImageResource> imageCache = new LinkedHashMap<String, ImageResource>(16, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, ImageResource> eldest) {
            return this.size() > 16;
        }
    };

    public CSSResource getCSSResource(String uri) {
        InputStream is = null;
        uri = this.resolveURI(uri);
        try {
            URLConnection uc = new URL(uri).openConnection();
            uc.connect();
            is = uc.getInputStream();
        }
        catch (MalformedURLException e) {
            XRLog.exception((String)("bad URL given: " + uri), (Throwable)e);
        }
        catch (IOException e) {
            XRLog.exception((String)("IO problem for " + uri), (Throwable)e);
        }
        return new CSSResource(is);
    }

    public ImageResource getImageResource(String uri) {
        ImageResource ir = this.imageCache.get(uri = this.resolveURI(uri));
        if (ir == null) {
            InputStream is = null;
            try {
                URLConnection uc = new URL(uri).openConnection();
                uc.connect();
                is = uc.getInputStream();
            }
            catch (MalformedURLException e1) {
                XRLog.exception((String)("bad URL given: " + uri), (Throwable)e1);
            }
            catch (IOException e11) {
                XRLog.exception((String)("IO problem for " + uri), (Throwable)e11);
            }
            if (is != null) {
                try {
                    BufferedImage img = ImageIO.read(is);
                    ir = new ImageResource(uri, AWTFSImage.createImage((Image)img));
                    this.imageCache.put(uri, ir);
                }
                catch (IOException e) {
                    XRLog.exception((String)("Can't read image file; unexpected problem for URI '" + uri + "'"), (Throwable)e);
                }
            }
        }
        if (ir == null) {
            ir = new ImageResource(uri, null);
        }
        return ir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBinaryResource(String uri) {
        InputStream is = null;
        try {
            int i;
            URL url = new URL(uri);
            URLConnection conn = url.openConnection();
            is = conn.getInputStream();
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            byte[] buf = new byte[10240];
            while ((i = is.read(buf)) != -1) {
                result.write(buf, 0, i);
            }
            is.close();
            is = null;
            byte[] byArray = result.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLResource getXMLResource(String uri) {
        if ((uri = this.resolveURI(uri)) != null && uri.startsWith("file:")) {
            try {
                new File(new URI(uri));
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        XMLResource xr = null;
        InputStream inputStream = null;
        try {
            URLConnection uc = new URL(uri).openConnection();
            uc.connect();
            inputStream = uc.getInputStream();
            xr = XMLResource.load((InputStream)inputStream);
        }
        catch (MalformedURLException e) {
            XRLog.exception((String)("bad URL given: " + uri), (Throwable)e);
        }
        catch (IOException e) {
            XRLog.exception((String)("IO problem for " + uri), (Throwable)e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
        }
        if (xr == null) {
            String notFound = "<h1>Document not found</h1>";
            xr = XMLResource.load((Reader)new StringReader(notFound));
        }
        return xr;
    }

    public boolean isVisited(String uri) {
        if (uri == null) {
            return false;
        }
        uri = this.resolveURI(uri);
        return this.history.contains(uri);
    }

    public void setBaseURL(String url) {
        String historic;
        this.baseUrl = this.resolveURI(url);
        if (this.baseUrl == null) {
            this.baseUrl = "error:FileNotFound";
        }
        if (this.index >= 0 && (historic = this.history.get(this.index)).equals(this.baseUrl)) {
            return;
        }
        ++this.index;
        int i = this.index;
        while (i < this.history.size()) {
            this.history.remove(i);
        }
        this.history.add(this.index, this.baseUrl);
    }

    public String resolveURI(String uri) {
        URL ref = null;
        if (uri == null) {
            return this.baseUrl;
        }
        if (uri.trim().equals("")) {
            return this.baseUrl;
        }
        if (uri.startsWith("demo:")) {
            DemoMarker marker = new DemoMarker();
            String short_url = uri.substring(5);
            if (!short_url.startsWith("/")) {
                short_url = "/" + short_url;
            }
            ref = marker.getClass().getResource(short_url);
            Uu.p((Object)("ref = " + ref));
        } else {
            try {
                if (this.baseUrl == null || this.baseUrl.length() == 0) {
                    ref = new URL(uri);
                } else {
                    URL base = new URL(this.baseUrl);
                    ref = new URL(base, uri);
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        if (ref == null) {
            return null;
        }
        return ref.toExternalForm();
    }

    public String getBaseURL() {
        return this.baseUrl;
    }

    public String getForward() {
        ++this.index;
        return this.history.get(this.index);
    }

    public String getBack() {
        --this.index;
        return this.history.get(this.index);
    }

    public boolean hasForward() {
        return this.index + 1 < this.history.size() && this.index >= 0;
    }

    public boolean hasBack() {
        return this.index >= 0;
    }
}

