/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.w3c.dom.Document;
import org.xhtmlrenderer.event.DefaultDocumentListener;
import org.xhtmlrenderer.event.DocumentListener;
import org.xhtmlrenderer.extend.ReplacedElementFactory;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.resource.XMLResource;
import org.xhtmlrenderer.simple.FSScrollPane;
import org.xhtmlrenderer.simple.XHTMLPanel;
import org.xhtmlrenderer.swing.DelegatingUserAgent;
import org.xhtmlrenderer.swing.ImageResourceLoader;
import org.xhtmlrenderer.swing.RepaintListener;
import org.xhtmlrenderer.swing.SwingReplacedElementFactory;
import org.xhtmlrenderer.util.GeneralUtil;

public class BrowsePanel {
    private String uri;
    private XHTMLPanel panel;
    private JFrame frame;
    private UserAgentCallback uac;

    public static void main(String[] args) {
        try {
            new BrowsePanel().run(args);
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
        }
    }

    private void run(String[] args) {
        this.loadAndCheckArgs(args);
        EventQueue.invokeLater(() -> {
            this.panel = new XHTMLPanel();
            this.setupDocumentListener(this.panel);
            this.setupUserAgentCallback(this.panel);
            FSScrollPane scroll = new FSScrollPane((JPanel)this.panel);
            this.frame = new JFrame("Flying Saucer");
            this.frame.setDefaultCloseOperation(3);
            this.frame.getContentPane().add((Component)scroll);
            this.frame.pack();
            this.frame.setSize(1024, 768);
            this.frame.setVisible(true);
            this.launchLoad();
        });
    }

    private void setupUserAgentCallback(XHTMLPanel panel) {
        this.uac = new DelegatingUserAgent();
        ImageResourceLoader irl = new ImageResourceLoader();
        irl.setRepaintListener((RepaintListener)panel);
        ((DelegatingUserAgent)this.uac).setImageResourceLoader(irl);
        panel.getSharedContext().setUserAgentCallback(this.uac);
        panel.getSharedContext().setReplacedElementFactory((ReplacedElementFactory)new SwingReplacedElementFactory((RepaintListener)panel, irl));
    }

    private void setupDocumentListener(final XHTMLPanel panel) {
        panel.addDocumentListener((DocumentListener)new DefaultDocumentListener(){

            public void documentStarted() {
                panel.setCursor(new Cursor(3));
                super.documentStarted();
            }

            public void documentLoaded() {
                panel.setCursor(new Cursor(0));
                BrowsePanel.this.frame.setTitle(panel.getDocumentTitle());
            }

            public void onLayoutException(Throwable t) {
                panel.setCursor(new Cursor(0));
                panel.setDocument(BrowsePanel.this.getErrorDocument("can't layout: " + t.getMessage()).getDocument());
            }

            public void onRenderException(Throwable t) {
                panel.setCursor(new Cursor(0));
                panel.setDocument(BrowsePanel.this.getErrorDocument("can't render: " + t.getMessage()).getDocument());
            }
        });
    }

    private XMLResource getErrorDocument(String reason) {
        String cleanUri = GeneralUtil.escapeHTML((String)this.uri);
        String notFound = "<html><h1>Document not found</h1><p>Could not load URI <pre>" + cleanUri + "</pre>, because: " + reason + "</p></html>";
        XMLResource xr = XMLResource.load((Reader)new StringReader(notFound));
        return xr;
    }

    private void launchLoad() {
        new Thread(() -> {
            Document doc;
            try {
                if (this.panel != null) {
                    this.panel.setCursor(new Cursor(3));
                }
                doc = this.getUAC().getXMLResource(this.uri).getDocument();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("Can't load document");
                return;
            }
            finally {
                if (this.panel != null) {
                    this.panel.setCursor(new Cursor(0));
                }
            }
            EventQueue.invokeLater(() -> this.startRender(doc));
        }).start();
    }

    private UserAgentCallback getUAC() {
        return this.uac;
    }

    private void startRender(Document document) {
        try {
            this.panel.setDocument(document, this.uri);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadAndCheckArgs(String[] args) {
        if (args.length == 0) {
            throw new IllegalArgumentException("Enter a file or URI.");
        }
        String name = args[0];
        if (!new File(name).exists()) {
            try {
                new URL(name);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("File " + name + " does not exist or is not a URI");
            }
        }
        this.uri = name;
    }
}

