/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.demo.browser;

import java.awt.Component;
import java.awt.EventQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import org.xhtmlrenderer.demo.browser.BrowserActions;
import org.xhtmlrenderer.demo.browser.BrowserMenuBar;
import org.xhtmlrenderer.demo.browser.BrowserPanel;
import org.xhtmlrenderer.demo.browser.BrowserPanelListener;
import org.xhtmlrenderer.demo.browser.ValidationHandler;
import org.xhtmlrenderer.util.GeneralUtil;
import org.xhtmlrenderer.util.XRLog;

public class BrowserStartup {
    public BrowserPanel panel;
    protected BrowserMenuBar menu;
    protected JFrame frame;
    protected JFrame validation_console = null;
    protected BrowserActions actions;
    protected String startPage;
    protected ValidationHandler error_handler = new ValidationHandler();
    public static final Logger logger = Logger.getLogger("app.browser");

    public BrowserStartup() {
        this("demo:demos/splash/splash.html");
    }

    public BrowserStartup(String startPage) {
        logger.info("starting up");
        this.startPage = startPage;
    }

    public void initUI() {
        if (GeneralUtil.isMacOSX()) {
            try {
                System.setProperty("apple.laf.useScreenMenuBar", "true");
                System.setProperty("com.apple.mrj.application.apple.menu.about.name", "FS Browser");
            }
            catch (Exception ex) {
                try {
                    logger.log(Level.SEVERE, "error initalizing the mac properties", ex);
                }
                catch (Exception exception) {}
            }
        } else {
            BrowserStartup.setLookAndFeel();
        }
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        this.frame = frame;
        logger.info("creating UI");
        this.actions = new BrowserActions(this);
        this.actions.init();
        this.panel = new BrowserPanel(this, new FrameBrowserPanelListener());
        this.panel.init();
        this.panel.createActions();
        this.menu = new BrowserMenuBar(this);
        this.menu.init();
        this.menu.createLayout();
        this.menu.createActions();
        frame.setJMenuBar(this.menu);
        frame.getContentPane().add((Component)this.panel.toolbar, "First");
        frame.getContentPane().add((Component)this.panel, "Center");
        this.panel.setBorder(new EtchedBorder(1));
        frame.getContentPane().add((Component)this.panel.status, "Last");
        frame.pack();
        frame.setSize(1024, 768);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                BrowserStartup bs = new BrowserStartup();
                bs.initUI();
                bs.launch();
            }
        });
    }

    public void launch() {
        try {
            this.panel.loadPage(this.startPage);
            this.frame.setVisible(true);
        }
        catch (Exception ex) {
            XRLog.general((Level)Level.SEVERE, (String)ex.getMessage(), (Throwable)ex);
        }
    }

    private static void setLookAndFeel() {
        boolean lnfSet = false;
        try {
            UIManager.setLookAndFeel("com.jgoodies.looks.plastic.PlasticXPLookAndFeel");
            lnfSet = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!lnfSet) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                lnfSet = true;
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        }
    }

    class FrameBrowserPanelListener
    implements BrowserPanelListener {
        FrameBrowserPanelListener() {
        }

        @Override
        public void pageLoadSuccess(String url, String title) {
            BrowserStartup.this.frame.setTitle(title + (title.length() > 0 ? " - " : "") + "Flying Saucer");
        }
    }
}

