/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.util.logging.Level;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.xhtmlrenderer.event.DefaultDocumentListener;
import org.xhtmlrenderer.event.DocumentListener;
import org.xhtmlrenderer.simple.XHTMLPanel;
import org.xhtmlrenderer.util.XRLog;

public class JPanelSizeToDocument {
    private String fileName;
    private int targetWidth = 800;

    public static void main(String[] args) throws Exception {
        new JPanelSizeToDocument().run(args);
    }

    private void run(String[] args) {
        this.loadAndCheckArgs(args);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JPanelSizeToDocument.this.launchGUI();
            }
        });
    }

    private void launchGUI() {
        final JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        final XHTMLPanel panel = new XHTMLPanel();
        Dimension orgSize = panel.getSize();
        panel.addDocumentListener((DocumentListener)new DefaultDocumentListener(){

            public void documentLoaded() {
                frame.setTitle("Flying Saucer: " + panel.getDocumentTitle());
                Dimension dim = panel.getPreferredSize();
                XRLog.general((String)("Preferred size" + dim));
            }
        });
        frame.getContentPane().add((Component)panel);
        try {
            panel.setDocument(new File(this.fileName));
        }
        catch (Exception e) {
            XRLog.general((Level)Level.WARNING, (String)("Could not load XHTML document " + this.fileName), (Throwable)e);
            this.messageAndExit("Failed to load document", -1);
        }
        frame.pack();
        panel.setSize(this.targetWidth, 10000);
        panel.doDocumentLayout(panel.getGraphics());
        panel.setSize(orgSize);
        frame.pack();
        frame.setVisible(true);
    }

    private void loadAndCheckArgs(String[] args) {
        String name;
        if (args.length == 0) {
            this.messageAndExit("Enter a file or URI.", -1);
        }
        if (!new File(name = args[0]).exists()) {
            this.messageAndExit("File " + name + " does not exist.", -1);
        }
        this.fileName = name;
        if (args.length > 1) {
            String widthVal = args[1];
            try {
                this.targetWidth = Integer.valueOf(widthVal);
            }
            catch (NumberFormatException e) {
                this.messageAndExit("Target width " + widthVal + " is not an integer", -1);
            }
        }
    }

    private void messageAndExit(String msg, int rtnCode) {
        System.out.println(msg);
        System.exit(rtnCode);
    }
}

