/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.demo.browser;

import com.google.errorprone.annotations.CheckReturnValue;
import java.io.File;
import java.net.MalformedURLException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xhtmlrenderer.util.GeneralUtil;

public class DirectoryLister {
    private static final Logger log = LoggerFactory.getLogger(DirectoryLister.class);

    @CheckReturnValue
    public static String list(File file) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append("<head>");
        sb.append("<title>Directory listing for ");
        sb.append(file.getPath());
        sb.append("</title>");
        sb.append("<style>");
        sb.append("body { font-family: monospaced; }");
        sb.append("ul { background-color: #ddffdd; }");
        sb.append("li { list-style-type: none; }");
        sb.append("a { text-decoration: none; }");
        sb.append(".dir { font-weight: bold; color: #ff9966; }");
        sb.append(".file { font-weight: normal; color: #003333; }");
        sb.append("</style>");
        sb.append("</head>");
        sb.append("<body>");
        sb.append("<h2>Index of ");
        sb.append(file);
        sb.append("</h2>");
        sb.append("<hr />");
        if (file.isDirectory()) {
            File[] files;
            File parent = file.getAbsoluteFile().getParentFile();
            try {
                if (parent != null) {
                    String loc = GeneralUtil.htmlEscapeSpace((String)parent.toURI().toURL().toExternalForm()).toString();
                    sb.append("<a class='dir' href='").append(loc).append("'>Up to higher level directory</a>");
                }
            }
            catch (MalformedURLException e) {
                log.warn("Cannot convert parent folder name to URL: {}, caused by: {}", (Object)parent, (Object)e.toString());
            }
            sb.append("<table style='width: 75%'>");
            for (File f : files = Objects.requireNonNullElseGet(file.listFiles(), () -> new File[0])) {
                if (f.isHidden()) continue;
                long len = f.length();
                String lenDesc = len > 1024L ? new DecimalFormat("#,###KB").format(len / 1024L) : "";
                String lastMod = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss a").format(new Date(f.lastModified()));
                sb.append("<tr>");
                String cls = f.isDirectory() ? "dir" : "file";
                try {
                    String loc = GeneralUtil.htmlEscapeSpace((String)f.toURI().toURL().toExternalForm()).toString();
                    sb.append("<td><a class='").append(cls).append("' href='").append(loc).append("'>").append(f.getName()).append("</a></td>");
                    sb.append("<td>").append(lenDesc).append("</td>").append("<td>").append(lastMod).append("</td>");
                }
                catch (MalformedURLException e) {
                    log.warn("Cannot convert file name to URL: {}, caused by: {}", (Object)f, (Object)e.toString());
                    sb.append(f.getAbsolutePath());
                }
                sb.append("</tr>");
            }
            sb.append("</table>");
        }
        sb.append("<hr />");
        sb.append("</body></html>");
        return sb.toString();
    }
}

