/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.snappy;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public class SnappyCodec {
    public static final byte[] MAGIC_HEADER = new byte[]{-126, 83, 78, 65, 80, 80, 89, 0};
    public static final int MAGIC_LEN = 8;
    public static final int DEFAULT_VERSION = 1;
    public static final int MINIMUM_COMPATIBLE_VERSION = 1;
    public final byte[] magic;
    public final int version;
    public final int compatibleVersion;

    private SnappyCodec(byte[] byArray, int n, int n2) {
        this.magic = byArray;
        this.version = n;
        this.compatibleVersion = n2;
    }

    public String toString() {
        return String.format("version:%d, compatible version:%d", this.version, this.compatibleVersion);
    }

    public static int headerSize() {
        return 16;
    }

    public void writeHeader(OutputStream outputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.write(this.magic, 0, 8);
        dataOutputStream.writeInt(this.version);
        dataOutputStream.writeInt(this.compatibleVersion);
        dataOutputStream.close();
        outputStream.write(byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size());
    }

    public boolean isValidMagicHeader() {
        return Arrays.equals(MAGIC_HEADER, this.magic);
    }

    public static SnappyCodec readHeader(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        byte[] byArray = new byte[8];
        dataInputStream.readFully(byArray, 0, 8);
        int n = dataInputStream.readInt();
        int n2 = dataInputStream.readInt();
        return new SnappyCodec(byArray, n, n2);
    }

    public static SnappyCodec currentHeader() {
        return new SnappyCodec(MAGIC_HEADER, 1, 1);
    }
}

