/*
 * Decompiled with CFR 0.152.
 */
package org.xenei.contracts.maven;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.realm.DuplicateRealmException;
import org.codehaus.plexus.util.StringUtils;
import org.xenei.classpathutils.ClassPathFilter;
import org.xenei.classpathutils.ClassPathUtils;
import org.xenei.classpathutils.filter.NotClassFilter;
import org.xenei.classpathutils.filter.parser.Parser;
import org.xenei.contracts.maven.ReportConfig;
import org.xenei.junit.contract.Contract;
import org.xenei.junit.contract.ContractImpl;
import org.xenei.junit.contract.NoContractTest;
import org.xenei.junit.contract.tooling.InterfaceInfo;
import org.xenei.junit.contract.tooling.InterfaceReport;

@Mojo(name="contract-test", defaultPhase=LifecyclePhase.PROCESS_TEST_CLASSES, requiresDependencyResolution=ResolutionScope.TEST)
public class ContractMojo
extends AbstractMojo {
    @Parameter
    private String[] packages;
    @Parameter
    private String skipFilter;
    private ClassPathFilter filter = ClassPathFilter.TRUE;
    @Parameter
    private ReportConfig untested;
    @Parameter
    private ReportConfig unimplemented;
    @Parameter
    private boolean failOnError = true;
    @Parameter
    private ReportConfig errors;
    @Parameter(defaultValue="${project.build.outputDirectory}", readonly=true)
    private File classDir;
    @Parameter(defaultValue="${project.build.testOutputDirectory}", readonly=true)
    private File testDir;
    @Parameter(defaultValue="${project.build.directory}", readonly=true)
    private File target;
    @Component
    private MavenProject project;
    @Parameter(defaultValue="${plugin.artifactMap}", required=true, readonly=true)
    private Map<String, Artifact> pluginArtifactMap;
    @Component
    private RepositorySystem repositorySystem;
    @Parameter(defaultValue="${localRepository}", required=true, readonly=true)
    private ArtifactRepository localRepository;
    private Set<Artifact> junitContractsArtifacts;
    private File myDir;
    private final StringBuilder failureMessage = new StringBuilder();

    public void setPackages(String[] packages) {
        this.packages = packages;
    }

    public void setSkipFilter(String filter) throws MojoExecutionException {
        if (StringUtils.isBlank((String)filter)) {
            this.filter = ClassPathFilter.TRUE;
        } else {
            try {
                this.filter = new NotClassFilter(new Parser().parse(filter));
            }
            catch (IllegalArgumentException e) {
                throw new MojoExecutionException(String.format("Could not create parse filter: %s", filter, e.getMessage()), (Exception)e);
            }
        }
    }

    public void setErrors(ReportConfig errors) {
        this.errors = errors;
    }

    public void setUntested(ReportConfig untested) {
        this.untested = untested;
    }

    public void setUnimplemented(ReportConfig unimplemented) {
        this.unimplemented = unimplemented;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    private void mojoError(String err) throws MojoExecutionException {
        if (this.failOnError) {
            this.getLog().error((CharSequence)err);
            throw new MojoExecutionException(err);
        }
        this.getLog().info((CharSequence)err);
    }

    private void mojoError(String err, Throwable throwable) throws MojoExecutionException {
        if (this.failOnError) {
            this.getLog().error((CharSequence)err, throwable);
            throw new MojoExecutionException(err, throwable);
        }
        this.getLog().info((CharSequence)err, throwable);
    }

    public void execute() throws MojoExecutionException {
        boolean success = true;
        try {
            InterfaceReport ir;
            if (this.packages == null || this.packages.length == 0) {
                this.mojoError("At least one package must be specified");
                return;
            }
            if (this.getLog().isInfoEnabled()) {
                for (String s : this.packages) {
                    this.getLog().info((CharSequence)("Processing package: " + s));
                }
                this.getLog().info((CharSequence)("Skip filter: " + this.filter));
            }
            this.myDir = new File(this.target, "contract-reports");
            if (!this.myDir.exists()) {
                this.myDir.mkdirs();
            }
            try {
                ir = new InterfaceReport(this.packages, this.filter, this.buildClassLoader());
            }
            catch (IllegalArgumentException e1) {
                this.mojoError("Could not create Interface report class", e1);
                return;
            }
            this.doReportInterfaces(ir);
            success &= this.doReportUntested(ir.getUntestedInterfaces());
            success &= this.doReportUnimplemented(ir.getUnImplementedTests());
            if (!(success &= this.doReportErrors(ir.getErrors()))) {
                this.mojoError(this.failureMessage.toString());
            }
        }
        catch (RuntimeException e) {
            this.mojoError(e.getMessage(), e);
        }
    }

    private void addFailureMessage(String msg) {
        this.addFailureMessage(msg, null);
    }

    private void addFailureMessage(String msg, Exception e) {
        if (this.failureMessage.length() > 0) {
            this.failureMessage.append(System.getProperty("line.separator"));
        }
        if (e == null) {
            this.getLog().warn((CharSequence)msg);
        } else {
            this.getLog().warn((CharSequence)msg, (Throwable)e);
        }
        this.failureMessage.append(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doReportInterfaces(InterfaceReport ir) {
        BufferedWriter bw = null;
        try {
            String entry;
            bw = new BufferedWriter(new FileWriter(new File(this.myDir, "interfaces.txt")));
            bw.write(String.format("Filter: %s", ir.getClassFilter()));
            bw.newLine();
            bw.newLine();
            bw.write("A list of all interfaces that meet the filter and their contract tests");
            bw.newLine();
            bw.write("----------------------------------------------------------------------");
            bw.newLine();
            bw.newLine();
            for (InterfaceInfo ii : ir.getInterfaceInfoCollection()) {
                if (!ir.getClassFilter().accept(ii.getName())) continue;
                entry = String.format("Interface: %s %s", ii.getName().getName(), ii.getTests());
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)entry);
                }
                bw.write(entry);
                bw.newLine();
            }
            bw.newLine();
            bw.write("A list of all classes that meet the filter");
            bw.newLine();
            bw.write("------------------------------------------");
            bw.newLine();
            bw.newLine();
            for (Class cls : ir.getClassFilter().filterClasses(ir.getPackageClasses())) {
                entry = String.format("Class: %s, contract: %s, impl: %s, flg: %s, all: %s", cls.getName(), cls.getAnnotation(Contract.class) != null, cls.getAnnotation(ContractImpl.class) != null, cls.getAnnotation(NoContractTest.class) != null, Arrays.asList(cls.getAnnotations()));
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)entry);
                }
                bw.write(entry);
                bw.newLine();
            }
            IOUtils.closeQuietly((Writer)bw);
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)e.getMessage(), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(bw);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doReportUntested(Set<Class<?>> untestedInterfaces) {
        if (!untestedInterfaces.isEmpty()) {
            if (this.untested.isReporting()) {
                BufferedWriter bw = null;
                try {
                    bw = new BufferedWriter(new FileWriter(new File(this.myDir, "untested.txt")));
                    bw.write("Interfaces that are defined in the list of packages but that");
                    bw.newLine();
                    bw.write("do not have contract tests and are not annotated with NoContractTest.");
                    bw.newLine();
                    bw.write("---------------------------------------------------------------------");
                    bw.newLine();
                    bw.newLine();
                    bw.write(String.format("Filter: %s", this.untested.getFilter()));
                    bw.newLine();
                    bw.newLine();
                    for (Class c : this.untested.getFilter().filterClasses(untestedInterfaces)) {
                        bw.write(c.getName());
                        bw.newLine();
                    }
                    IOUtils.closeQuietly((Writer)bw);
                }
                catch (IOException e) {
                    this.addFailureMessage("Unable to write untested report", e);
                    boolean bl = false;
                    return bl;
                }
                finally {
                    IOUtils.closeQuietly(bw);
                }
            }
            if (this.untested.isFailOnError() && !this.untested.getFilter().filterClasses(untestedInterfaces).isEmpty()) {
                this.addFailureMessage("Untested Interfaces Exist");
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doReportUnimplemented(Set<Class<?>> unimplementedTests) {
        if (!unimplementedTests.isEmpty()) {
            if (this.unimplemented.isReporting()) {
                BufferedWriter bw = null;
                try {
                    bw = new BufferedWriter(new FileWriter(new File(this.myDir, "unimplemented.txt")));
                    bw.write("Classes that implement an interface that has a Contract test");
                    bw.newLine();
                    bw.write("but for which no contract suite test implementation is found.");
                    bw.newLine();
                    bw.write("-------------------------------------------------------------");
                    bw.newLine();
                    bw.newLine();
                    bw.write(String.format("Filter: %s", this.unimplemented.getFilter()));
                    bw.newLine();
                    bw.newLine();
                    for (Class c : this.unimplemented.getFilter().filterClasses(unimplementedTests)) {
                        bw.write(c.getName());
                        bw.newLine();
                    }
                    IOUtils.closeQuietly((Writer)bw);
                }
                catch (IOException e) {
                    this.addFailureMessage("Unable to write unimplemented report", e);
                    boolean bl = false;
                    return bl;
                }
                finally {
                    IOUtils.closeQuietly(bw);
                }
            }
            if (this.unimplemented.isFailOnError() && !this.unimplemented.getFilter().filterClasses(unimplementedTests).isEmpty()) {
                this.addFailureMessage("Unimplemented Tests Exist");
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doReportErrors(List<Throwable> errorLst) {
        if (!errorLst.isEmpty()) {
            if (this.errors.isReporting()) {
                BufferedWriter bw = null;
                try {
                    bw = new BufferedWriter(new FileWriter(new File(this.myDir, "errors.txt")));
                    for (Throwable t : errorLst) {
                        bw.write(t.toString());
                        bw.newLine();
                    }
                    IOUtils.closeQuietly((Writer)bw);
                }
                catch (IOException e) {
                    this.addFailureMessage("Unable to write error report", e);
                    boolean bl = false;
                    return bl;
                }
                finally {
                    IOUtils.closeQuietly(bw);
                }
            }
            if (this.errors.isFailOnError()) {
                this.addFailureMessage("Contract Test Errors Exist");
                return false;
            }
        }
        return true;
    }

    private ClassLoader buildClassLoader() throws MojoExecutionException {
        ClassRealm realm;
        ClassWorld world = new ClassWorld();
        try {
            URL url;
            realm = world.newRealm("contract", null);
            for (Object elt : this.getJunitContractsArtifacts()) {
                String dir = String.format("%s!/", elt.getFile().toURI().toURL());
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Checking for imports from: " + dir));
                }
                try {
                    Set classNames = ClassPathUtils.findClasses((String)dir, (String)"org.xenei.junit.contract");
                    for (String clsName : classNames) {
                        if (this.getLog().isDebugEnabled()) {
                            this.getLog().debug((CharSequence)("Importing from current classloader: " + clsName));
                        }
                        this.importFromCurrentClassLoader(realm, Class.forName(clsName));
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new MojoExecutionException(e.toString(), (Exception)e);
                }
                catch (IOException e) {
                    throw new MojoExecutionException(e.toString(), (Exception)e);
                }
            }
            for (Object elt : this.project.getCompileSourceRoots()) {
                url = new File((String)elt).toURI().toURL();
                realm.addURL(url);
                if (!this.getLog().isDebugEnabled()) continue;
                this.getLog().debug((CharSequence)("Source root: " + url));
            }
            for (Object elt : this.project.getCompileClasspathElements()) {
                url = new File((String)elt).toURI().toURL();
                realm.addURL(url);
                if (!this.getLog().isDebugEnabled()) continue;
                this.getLog().debug((CharSequence)("Compile classpath: " + url));
            }
            for (Object elt : this.project.getTestClasspathElements()) {
                url = new File((String)elt).toURI().toURL();
                realm.addURL(url);
                if (!this.getLog().isDebugEnabled()) continue;
                this.getLog().debug((CharSequence)("Test classpath: " + url));
            }
        }
        catch (DuplicateRealmException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        return realm;
    }

    private void importFromCurrentClassLoader(ClassRealm realm, Class<?> cls) {
        if (cls == null) {
            return;
        }
        realm.importFrom(Thread.currentThread().getContextClassLoader(), cls.getName());
        for (Class<?> intf : cls.getInterfaces()) {
            this.importFromCurrentClassLoader(realm, intf);
        }
        this.importFromCurrentClassLoader(realm, cls.getSuperclass());
    }

    private Set<Artifact> getJunitContractsArtifacts() {
        if (this.junitContractsArtifacts == null) {
            ArtifactResolutionRequest request = new ArtifactResolutionRequest().setArtifact(this.pluginArtifactMap.get("org.xenei:junit-contracts")).setResolveTransitively(true).setLocalRepository(this.localRepository);
            ArtifactResolutionResult result = this.repositorySystem.resolve(request);
            this.junitContractsArtifacts = result.getArtifacts();
        }
        return this.junitContractsArtifacts;
    }
}

