package org.xelevra.architecture.view;

import android.databinding.DataBindingUtil;
import android.databinding.ViewDataBinding;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;

import java.util.List;

public class DataBindingRecyclerAdapter<ItemType, BindingType extends ViewDataBinding> extends RecyclerView.Adapter<DataBindingRecyclerAdapter.BindingViewHolder> implements DataBindingAdapter<BindingType> {
    protected final List<ItemType> items;
    private final int layoutId, itemId;
    private DataBindingAdapter<BindingType> realisation;

    public DataBindingRecyclerAdapter(List<ItemType> items, int layoutId, int itemId) {
        this.items = items;
        this.layoutId = layoutId;
        this.itemId = itemId;
    }

    public DataBindingRecyclerAdapter(List<ItemType> items, int layoutId, int itemId, DataBindingAdapter<BindingType> realisation){
        this(items, layoutId, itemId);
        this.realisation = realisation;
    }

    private AdapterView.OnItemClickListener onItemClickListener;


    public void setOnItemClickListener(AdapterView.OnItemClickListener onItemClickListener) {
        this.onItemClickListener = onItemClickListener;
    }

    @Override
    public BindingViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        BindingType binding = DataBindingUtil.inflate(LayoutInflater.from(parent.getContext()), layoutId, parent, false);
        onCreate(binding);
        final BindingViewHolder result = new BindingViewHolder(binding);
        if(onItemClickListener != null){
            binding.getRoot().setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    if(onItemClickListener != null) {
                        onItemClickListener.onItemClick(null, view, result.position, view.getId());
                    }
                }
            });
        }
        return result;
    }

    @Override
    public void onBindViewHolder(BindingViewHolder holder, int position) {
        holder.position = position;
        holder.binding.setVariable(itemId, items.get(position));
        onBind((BindingType) holder.binding, position);
        holder.binding.executePendingBindings();
    }

    @Override
    public int getItemCount() {
        return items.size();
    }

    public void onCreate(final BindingType binding){
        if(realisation != null) realisation.onCreate(binding);
    }

    public void onBind(final BindingType binding, final int position){
        if(realisation != null) realisation.onBind(binding, position);
    }

    public static class BindingViewHolder extends RecyclerView.ViewHolder {
        private ViewDataBinding binding;

        public BindingViewHolder(ViewDataBinding binding) {
            super(binding.getRoot());
            this.binding = binding;
        }

        public int position;
    }
}
