package org.xelevra.architecture.base;

import android.os.Handler;
import android.os.Looper;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;

public class UIExecutor implements Executor {

    BlockingQueue<Runnable> commands;
    Handler handler;
    private final Object readyLock;
    private boolean ready;

    public UIExecutor(){
        commands = new LinkedBlockingQueue<>();
        readyLock = new Object();
        handler = new Handler(Looper.getMainLooper());
    }


    public void ready(){
        if(Looper.getMainLooper().getThread() != Thread.currentThread()) throw new IllegalStateException("Not main thread");
        synchronized (readyLock) {
            ready = true;
        }
        runCommands();
    }

    public void pause(){
        if(Looper.getMainLooper().getThread() != Thread.currentThread()) throw new IllegalStateException("Not main thread");
        synchronized (readyLock) {
            ready = false;
        }
    }


    @Override
    public void execute(Runnable command) {
        boolean isReady;
        synchronized (readyLock){
            isReady = ready && Thread.currentThread() == Looper.getMainLooper().getThread();
        }

        if(isReady){
            command.run();
        } else {
            executeNextFrame(command);
        }
    }

    public void executeNextFrame(Runnable command){
        commands.add(command);
        handler.postDelayed(checkAndRun, 1);
    }

    private Runnable checkAndRun = new Runnable() {
        @Override
        public void run() {
            synchronized (readyLock){
                if(!ready) return;
            }
            runCommands();
        }
    };

    private void runCommands(){
        Runnable command;
        while ((command = commands.poll()) != null){
            command.run();
        }
    }
}