/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ei.dataservice.integration.common.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Calendar;
import javax.activation.DataHandler;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.automation.test.utils.common.FileManager;
import org.wso2.carbon.automation.test.utils.common.TestConfigurationProvider;
import org.wso2.carbon.dataservices.ui.fileupload.stub.ExceptionException;
import org.wso2.ei.dataservices.integration.common.clients.DataServiceFileUploaderClient;
import org.wso2.ei.dataservices.integration.common.clients.ServiceAdminClient;

public class DSSTestCaseUtils {
    private Log log = LogFactory.getLog(DSSTestCaseUtils.class);
    private static int SERVICE_DEPLOYMENT_DELAY = TestConfigurationProvider.getServiceDeploymentDelay();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OMElement loadResourceFrom(String filePath) throws FileNotFoundException, XMLStreamException {
        OMElement documentElement = null;
        FileInputStream inputStream = null;
        XMLStreamReader parser = null;
        StAXOMBuilder builder = null;
        File file = new File(filePath);
        if (file.exists()) {
            try {
                inputStream = new FileInputStream(this.getClass().getResource(filePath).getPath());
                parser = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
                builder = new StAXOMBuilder(parser);
                documentElement = builder.getDocumentElement().cloneOMElement();
            }
            finally {
                if (builder != null) {
                    builder.close();
                }
                if (parser != null) {
                    try {
                        parser.close();
                    }
                    catch (XMLStreamException xMLStreamException) {}
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        throw new FileNotFoundException("File Not Exist at " + filePath);
        return documentElement;
    }

    public String getContentFrom(String filePath) throws IOException {
        return FileManager.readFile((File)new File(filePath));
    }

    public boolean uploadArtifact(String serviceUrl, String sessionCookie, String fileName, DataHandler dh) throws ExceptionException, RemoteException {
        DataServiceFileUploaderClient adminServiceDataServiceFileUploader = new DataServiceFileUploaderClient(serviceUrl, sessionCookie);
        return adminServiceDataServiceFileUploader.uploadDataServiceFile(fileName, dh);
    }

    public boolean isServiceDeployed(String backEndUrl, String sessionCookie, String serviceName) throws RemoteException {
        long time;
        this.log.info((Object)("waiting " + SERVICE_DEPLOYMENT_DELAY + " millis for service deployment"));
        boolean isServiceDeployed = false;
        ServiceAdminClient adminServiceService = new ServiceAdminClient(backEndUrl, sessionCookie);
        Calendar startTime = Calendar.getInstance();
        while ((time = Calendar.getInstance().getTimeInMillis() - startTime.getTimeInMillis()) < (long)SERVICE_DEPLOYMENT_DELAY) {
            if (adminServiceService.isServiceExists(serviceName)) {
                isServiceDeployed = true;
                this.log.info((Object)(serviceName + " Service Deployed in " + time + " millis"));
                break;
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return isServiceDeployed;
    }

    public boolean isServiceFaulty(String backEndUrl, String sessionCookie, String serviceName) throws RemoteException {
        long time;
        boolean isServiceDeployed = false;
        ServiceAdminClient adminServiceService = new ServiceAdminClient(backEndUrl, sessionCookie);
        Calendar startTime = Calendar.getInstance();
        while ((time = Calendar.getInstance().getTimeInMillis() - startTime.getTimeInMillis()) < (long)SERVICE_DEPLOYMENT_DELAY) {
            if (adminServiceService.isServiceFaulty(serviceName)) {
                isServiceDeployed = true;
                break;
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return isServiceDeployed;
    }

    public boolean isServiceExist(String backEndUrl, String sessionCookie, String serviceName) throws RemoteException {
        ServiceAdminClient adminServiceService = new ServiceAdminClient(backEndUrl, sessionCookie);
        return adminServiceService.isServiceExists(serviceName);
    }

    public boolean isFaultyService(String backEndUrl, String sessionCookie, String serviceName) throws RemoteException {
        ServiceAdminClient adminServiceService = new ServiceAdminClient(backEndUrl, sessionCookie);
        return adminServiceService.isServiceFaulty(serviceName);
    }

    public void deleteService(String backEndUrl, String sessionCookie, String serviceName) throws RemoteException {
        ServiceAdminClient adminServiceService = new ServiceAdminClient(backEndUrl, sessionCookie);
        if (this.isFaultyService(backEndUrl, sessionCookie, serviceName)) {
            adminServiceService.deleteFaultyServiceByServiceName(serviceName);
        } else if (this.isServiceExist(backEndUrl, sessionCookie, serviceName)) {
            adminServiceService.deleteService(new String[]{adminServiceService.getServiceGroup(serviceName)});
        }
    }

    public boolean isServiceDeleted(String backEndUrl, String sessionCookie, String serviceName) throws RemoteException {
        long time;
        this.log.info((Object)("waiting " + SERVICE_DEPLOYMENT_DELAY + " millis for service undeployment"));
        ServiceAdminClient adminServiceService = new ServiceAdminClient(backEndUrl, sessionCookie);
        boolean isServiceDeleted = false;
        Calendar startTime = Calendar.getInstance();
        while ((time = Calendar.getInstance().getTimeInMillis() - startTime.getTimeInMillis()) < (long)SERVICE_DEPLOYMENT_DELAY) {
            if (!adminServiceService.isServiceExists(serviceName)) {
                isServiceDeleted = true;
                this.log.info((Object)(serviceName + " Service undeployed in " + time + " millis"));
                break;
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return isServiceDeleted;
    }
}

