/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ei.dataservice.integration.common.utils;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.AxisFault;
import org.testng.Assert;
import org.wso2.carbon.automation.test.utils.axis2client.AxisServiceClient;

public class SampleDataServiceClient {
    private final OMFactory fac = OMAbstractFactory.getOMFactory();
    private final OMNamespace omNs = this.fac.createOMNamespace("http://ws.wso2.org/dataservice/samples/rdbms_sample", "ns1");
    private String serviceEndpoint;

    public SampleDataServiceClient(String serviceEndpoint) {
        this.serviceEndpoint = serviceEndpoint;
    }

    public void getCustomerInBoston() throws AxisFault {
        OMElement payload = this.fac.createOMElement("customersInBoston", this.omNs);
        OMElement result = new AxisServiceClient().sendReceive(payload, this.serviceEndpoint, "customersInBoston");
        Assert.assertTrue((boolean)result.toString().contains("<city>Boston</city>"), (String)"Expected Result Mismatched");
    }

    public void addEmployee(String employeeNumber) throws AxisFault {
        OMElement payload = this.fac.createOMElement("addEmployee", this.omNs);
        OMElement empNo = this.fac.createOMElement("employeeNumber", this.omNs);
        empNo.setText(employeeNumber);
        payload.addChild((OMNode)empNo);
        OMElement lastName = this.fac.createOMElement("lastName", this.omNs);
        lastName.setText("BBB");
        payload.addChild((OMNode)lastName);
        OMElement fName = this.fac.createOMElement("firstName", this.omNs);
        fName.setText("AAA");
        payload.addChild((OMNode)fName);
        OMElement email = this.fac.createOMElement("email", this.omNs);
        email.setText("aaa@ccc.com");
        payload.addChild((OMNode)email);
        OMElement salary = this.fac.createOMElement("salary", this.omNs);
        salary.setText("50000");
        payload.addChild((OMNode)salary);
        new AxisServiceClient().sendRobust(payload, this.serviceEndpoint, "addEmployee");
    }

    public OMElement getEmployeeById(String employeeNumber) throws AxisFault {
        OMElement payload = this.fac.createOMElement("employeesByNumber", this.omNs);
        OMElement empNo = this.fac.createOMElement("employeeNumber", this.omNs);
        empNo.setText(employeeNumber);
        payload.addChild((OMNode)empNo);
        OMElement result = new AxisServiceClient().sendReceive(payload, this.serviceEndpoint, "employeesByNumber");
        return result;
    }

    public void increaseEmployeeSalary(String employeeNumber, String increment) throws AxisFault {
        OMElement payload = this.fac.createOMElement("incrementEmployeeSalary", this.omNs);
        OMElement empNo = this.fac.createOMElement("employeeNumber", this.omNs);
        empNo.setText(employeeNumber);
        payload.addChild((OMNode)empNo);
        OMElement salary = this.fac.createOMElement("increment", this.omNs);
        salary.setText(increment);
        payload.addChild((OMNode)salary);
        new AxisServiceClient().sendRobust(payload, this.serviceEndpoint, "incrementEmployeeSalary");
    }

    public void deleteEmployeeById(String employeeNumber) throws AxisFault {
        OMElement payload = this.fac.createOMElement("deleteEmployeeById", this.omNs);
        OMElement empNo = this.fac.createOMElement("employeeNumber", this.omNs);
        empNo.setText(employeeNumber);
        payload.addChild((OMNode)empNo);
        new AxisServiceClient().sendRobust(payload, this.serviceEndpoint, "deleteEmployeeById");
    }
}

