/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader.listener.simple;

import android.content.Context;
import android.text.TextUtils;
import android.widget.Toast;
import org.wlf.filedownloader.DownloadFileInfo;
import org.wlf.filedownloader.FileDownloadConfiguration;
import org.wlf.filedownloader.FileDownloader;
import org.wlf.filedownloader.listener.OnFileDownloadStatusListener;
import org.wlf.filedownloader.listener.OnRetryableFileDownloadStatusListener;

public abstract class OnSimpleFileDownloadStatusListener
implements OnRetryableFileDownloadStatusListener {
    @Override
    public void onFileDownloadStatusRetrying(DownloadFileInfo downloadFileInfo, int retryTimes) {
    }

    @Override
    public void onFileDownloadStatusWaiting(DownloadFileInfo downloadFileInfo) {
    }

    @Override
    public void onFileDownloadStatusPreparing(DownloadFileInfo downloadFileInfo) {
    }

    @Override
    public void onFileDownloadStatusPrepared(DownloadFileInfo downloadFileInfo) {
    }

    @Override
    public void onFileDownloadStatusDownloading(DownloadFileInfo downloadFileInfo, float downloadSpeed, long remainingTime) {
    }

    @Override
    public void onFileDownloadStatusPaused(DownloadFileInfo downloadFileInfo) {
    }

    @Override
    public void onFileDownloadStatusCompleted(DownloadFileInfo downloadFileInfo) {
        Context appContext = this.getAppContext();
        if (appContext != null) {
            String fileName;
            String string = fileName = downloadFileInfo != null ? downloadFileInfo.getFileName() : null;
            if (!TextUtils.isEmpty((CharSequence)fileName)) {
                Toast.makeText((Context)appContext, (CharSequence)("Download  " + fileName + "  completed !"), (int)0).show();
            }
        }
    }

    @Override
    public void onFileDownloadStatusFailed(String url, DownloadFileInfo downloadFileInfo, OnFileDownloadStatusListener.FileDownloadStatusFailReason failReason) {
        Context appContext = this.getAppContext();
        if (appContext != null) {
            String fileName;
            String string = fileName = downloadFileInfo != null ? downloadFileInfo.getFileName() : null;
            if (!TextUtils.isEmpty((CharSequence)fileName)) {
                Toast.makeText((Context)appContext, (CharSequence)("Download  " + fileName + "  error !"), (int)0).show();
            }
        }
    }

    private Context getAppContext() {
        Context appContext = null;
        if (FileDownloader.isInit()) {
            FileDownloadConfiguration configuration = FileDownloader.getFileDownloadConfiguration();
            appContext = configuration != null ? configuration.getContext() : null;
        }
        return appContext;
    }
}

