/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader.listener;

import android.os.Handler;
import android.os.Looper;
import org.wlf.filedownloader.DownloadFileInfo;
import org.wlf.filedownloader.base.FailReason;
import org.wlf.filedownloader.file_download.base.HttpFailReason;
import org.wlf.filedownloader.file_download.file_saver.FileSaver;
import org.wlf.filedownloader.file_download.http_downloader.HttpDownloader;
import org.wlf.filedownloader.listener.OnDetectUrlFileListener;

public interface OnFileDownloadStatusListener {
    public void onFileDownloadStatusWaiting(DownloadFileInfo var1);

    public void onFileDownloadStatusPreparing(DownloadFileInfo var1);

    public void onFileDownloadStatusPrepared(DownloadFileInfo var1);

    public void onFileDownloadStatusDownloading(DownloadFileInfo var1, float var2, long var3);

    public void onFileDownloadStatusPaused(DownloadFileInfo var1);

    public void onFileDownloadStatusCompleted(DownloadFileInfo var1);

    public void onFileDownloadStatusFailed(String var1, DownloadFileInfo var2, FileDownloadStatusFailReason var3);

    public static class FileDownloadStatusFailReason
    extends HttpFailReason {
        public static final String TYPE_URL_ILLEGAL = FileDownloadStatusFailReason.class.getName() + "_TYPE_URL_ILLEGAL";
        public static final String TYPE_URL_OVER_REDIRECT_COUNT = FileDownloadStatusFailReason.class.getName() + "_TYPE_URL_OVER_REDIRECT_COUNT";
        public static final String TYPE_BAD_HTTP_RESPONSE_CODE = FileDownloadStatusFailReason.class.getName() + "_TYPE_BAD_HTTP_RESPONSE_CODE";
        public static final String TYPE_HTTP_FILE_NOT_EXIST = FileDownloadStatusFailReason.class.getName() + "_TYPE_HTTP_FILE_NOT_EXIST";
        public static final String TYPE_FILE_SAVE_PATH_ILLEGAL = FileDownloadStatusFailReason.class.getName() + "_TYPE_FILE_SAVE_PATH_ILLEGAL";
        public static final String TYPE_STORAGE_SPACE_CAN_NOT_WRITE = FileDownloadStatusFailReason.class.getName() + "_TYPE_STORAGE_SPACE_CAN_NOT_WRITE";
        public static final String TYPE_RENAME_TEMP_FILE_ERROR = FileDownloadStatusFailReason.class.getName() + "_TYPE_RENAME_TEMP_FILE_ERROR";
        public static final String TYPE_STORAGE_SPACE_IS_FULL = FileDownloadStatusFailReason.class.getName() + "_TYPE_STORAGE_SPACE_IS_FULL";
        public static final String TYPE_SAVE_FILE_NOT_EXIST = FileDownloadStatusFailReason.class.getName() + "_TYPE_SAVE_FILE_NOT_EXIST";
        public static final String TYPE_FILE_NOT_DETECT = FileDownloadStatusFailReason.class.getName() + "_TYPE_FILE_NOT_DETECT";
        public static final String TYPE_DOWNLOAD_FILE_ERROR = FileDownloadStatusFailReason.class.getName() + "_TYPE_DOWNLOAD_FILE_ERROR";
        public static final String TYPE_URL_FILE_CHANGED = FileDownloadStatusFailReason.class.getName() + "_TYPE_URL_FILE_CHANGED";
        @Deprecated
        public static final String TYPE_FILE_IS_DOWNLOADING = FileDownloadStatusFailReason.class.getName() + "_TYPE_FILE_IS_DOWNLOADING";

        public FileDownloadStatusFailReason(String url, String detailMessage, String type) {
            super(url, detailMessage, type);
        }

        public FileDownloadStatusFailReason(String url, Throwable throwable) {
            super(url, throwable);
        }

        @Override
        protected void onInitTypeWithFailReason(FailReason failReason) {
            super.onInitTypeWithFailReason(failReason);
            if (failReason == null) {
                return;
            }
            if (failReason instanceof HttpFailReason) {
                HttpFailReason httpFailReason = (HttpFailReason)failReason;
                String type = httpFailReason.getType();
                this.setType(type);
                if (this.isTypeInit()) {
                    return;
                }
                if (failReason instanceof HttpDownloader.HttpDownloadException) {
                    HttpDownloader.HttpDownloadException httpDownloadException = (HttpDownloader.HttpDownloadException)failReason;
                    type = httpDownloadException.getType();
                    if (!HttpDownloader.HttpDownloadException.TYPE_CONTENT_RANGE_VALIDATE_FAIL.equals(type)) {
                        if (HttpDownloader.HttpDownloadException.TYPE_ETAG_CHANGED.equals(type)) {
                            this.setType(TYPE_URL_FILE_CHANGED);
                        } else if (HttpDownloader.HttpDownloadException.TYPE_REDIRECT_COUNT_OVER_LIMITS.equals(type)) {
                            this.setType(TYPE_URL_OVER_REDIRECT_COUNT);
                        } else if (HttpDownloader.HttpDownloadException.TYPE_RESOURCES_SIZE_ILLEGAL.equals(type)) {
                            this.setType(TYPE_DOWNLOAD_FILE_ERROR);
                        } else if (HttpDownloader.HttpDownloadException.TYPE_RESPONSE_CODE_ERROR.equals(type)) {
                            this.setType(TYPE_BAD_HTTP_RESPONSE_CODE);
                        }
                    }
                } else if (failReason instanceof OnDetectUrlFileListener.DetectUrlFileFailReason) {
                    OnDetectUrlFileListener.DetectUrlFileFailReason detectUrlFileFailReason = (OnDetectUrlFileListener.DetectUrlFileFailReason)failReason;
                    type = detectUrlFileFailReason.getType();
                    if (OnDetectUrlFileListener.DetectUrlFileFailReason.TYPE_BAD_HTTP_RESPONSE_CODE.equals(type)) {
                        this.setType(TYPE_BAD_HTTP_RESPONSE_CODE);
                    } else if (OnDetectUrlFileListener.DetectUrlFileFailReason.TYPE_HTTP_FILE_NOT_EXIST.equals(type)) {
                        this.setType(TYPE_FILE_NOT_DETECT);
                    } else if (OnDetectUrlFileListener.DetectUrlFileFailReason.TYPE_URL_ILLEGAL.equals(type)) {
                        this.setType(TYPE_URL_ILLEGAL);
                    } else if (OnDetectUrlFileListener.DetectUrlFileFailReason.TYPE_URL_OVER_REDIRECT_COUNT.equals(type)) {
                        this.setType(TYPE_URL_OVER_REDIRECT_COUNT);
                    }
                }
            } else if (failReason instanceof FileSaver.FileSaveException) {
                FileSaver.FileSaveException fileSaveException = (FileSaver.FileSaveException)failReason;
                String type = fileSaveException.getType();
                if (FileSaver.FileSaveException.TYPE_FILE_CAN_NOT_STORAGE.equals(type)) {
                    this.setType(TYPE_STORAGE_SPACE_CAN_NOT_WRITE);
                } else if (FileSaver.FileSaveException.TYPE_RENAME_TEMP_FILE_ERROR.equals(type)) {
                    this.setType(TYPE_RENAME_TEMP_FILE_ERROR);
                } else if (!FileSaver.FileSaveException.TYPE_SAVER_HAS_BEEN_STOPPED.equals(type) && FileSaver.FileSaveException.TYPE_TEMP_FILE_DOES_NOT_EXIST.equals(type)) {
                    this.setType(TYPE_SAVE_FILE_NOT_EXIST);
                }
            }
        }
    }

    @Deprecated
    public static class OnFileDownloadStatusFailReason
    extends FileDownloadStatusFailReason {
        public OnFileDownloadStatusFailReason(String url, String detailMessage, String type) {
            super(url, detailMessage, type);
        }

        public OnFileDownloadStatusFailReason(String url, Throwable throwable) {
            super(url, throwable);
        }
    }

    public static class MainThreadHelper {
        public static void onFileDownloadStatusWaiting(final DownloadFileInfo downloadFileInfo, final OnFileDownloadStatusListener onFileDownloadStatusListener) {
            if (onFileDownloadStatusListener == null) {
                return;
            }
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    if (onFileDownloadStatusListener == null) {
                        return;
                    }
                    onFileDownloadStatusListener.onFileDownloadStatusWaiting(downloadFileInfo);
                }
            });
        }

        public static void onFileDownloadStatusPreparing(final DownloadFileInfo downloadFileInfo, final OnFileDownloadStatusListener onFileDownloadStatusListener) {
            if (onFileDownloadStatusListener == null) {
                return;
            }
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    if (onFileDownloadStatusListener == null) {
                        return;
                    }
                    onFileDownloadStatusListener.onFileDownloadStatusPreparing(downloadFileInfo);
                }
            });
        }

        public static void onFileDownloadStatusPrepared(final DownloadFileInfo downloadFileInfo, final OnFileDownloadStatusListener onFileDownloadStatusListener) {
            if (onFileDownloadStatusListener == null) {
                return;
            }
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    if (onFileDownloadStatusListener == null) {
                        return;
                    }
                    onFileDownloadStatusListener.onFileDownloadStatusPrepared(downloadFileInfo);
                }
            });
        }

        public static void onFileDownloadStatusDownloading(final DownloadFileInfo downloadFileInfo, final float downloadSpeed, final long remainingTime, final OnFileDownloadStatusListener onFileDownloadStatusListener) {
            if (onFileDownloadStatusListener == null) {
                return;
            }
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    if (onFileDownloadStatusListener == null) {
                        return;
                    }
                    onFileDownloadStatusListener.onFileDownloadStatusDownloading(downloadFileInfo, downloadSpeed, remainingTime);
                }
            });
        }

        public static void onFileDownloadStatusPaused(final DownloadFileInfo downloadFileInfo, final OnFileDownloadStatusListener onFileDownloadStatusListener) {
            if (onFileDownloadStatusListener == null) {
                return;
            }
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    if (onFileDownloadStatusListener == null) {
                        return;
                    }
                    onFileDownloadStatusListener.onFileDownloadStatusPaused(downloadFileInfo);
                }
            });
        }

        public static void onFileDownloadStatusCompleted(final DownloadFileInfo downloadFileInfo, final OnFileDownloadStatusListener onFileDownloadStatusListener) {
            if (onFileDownloadStatusListener == null) {
                return;
            }
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    if (onFileDownloadStatusListener == null) {
                        return;
                    }
                    onFileDownloadStatusListener.onFileDownloadStatusCompleted(downloadFileInfo);
                }
            });
        }

        public static void onFileDownloadStatusFailed(final String url, final DownloadFileInfo downloadFileInfo, final FileDownloadStatusFailReason failReason, final OnFileDownloadStatusListener onFileDownloadStatusListener) {
            if (onFileDownloadStatusListener == null) {
                return;
            }
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    if (onFileDownloadStatusListener == null) {
                        return;
                    }
                    onFileDownloadStatusListener.onFileDownloadStatusFailed(url, downloadFileInfo, failReason);
                }
            });
        }
    }
}

