/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader.listener;

import android.os.Handler;
import android.os.Looper;
import org.wlf.filedownloader.file_download.base.HttpFailReason;

public interface OnDetectBigUrlFileListener {
    public void onDetectNewDownloadFile(String var1, String var2, String var3, long var4);

    public void onDetectUrlFileExist(String var1);

    public void onDetectUrlFileFailed(String var1, DetectBigUrlFileFailReason var2);

    public static class DetectBigUrlFileFailReason
    extends HttpFailReason {
        public static final String TYPE_URL_ILLEGAL = DetectBigUrlFileFailReason.class.getName() + "_TYPE_URL_ILLEGAL";
        public static final String TYPE_URL_OVER_REDIRECT_COUNT = DetectBigUrlFileFailReason.class.getName() + "_TYPE_URL_OVER_REDIRECT_COUNT";
        public static final String TYPE_BAD_HTTP_RESPONSE_CODE = DetectBigUrlFileFailReason.class.getName() + "_TYPE_BAD_HTTP_RESPONSE_CODE";
        public static final String TYPE_HTTP_FILE_NOT_EXIST = DetectBigUrlFileFailReason.class.getName() + "_TYPE_HTTP_FILE_NOT_EXIST";

        public DetectBigUrlFileFailReason(String url, String detailMessage, String type) {
            super(url, detailMessage, type);
        }

        public DetectBigUrlFileFailReason(String url, Throwable throwable) {
            super(url, throwable);
        }
    }

    public static class MainThreadHelper {
        public static void onDetectNewDownloadFile(final String url, final String fileName, final String saveDir, final long fileSize, final OnDetectBigUrlFileListener nnDetectBigUrlFileListener) {
            if (nnDetectBigUrlFileListener == null) {
                return;
            }
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    if (nnDetectBigUrlFileListener == null) {
                        return;
                    }
                    nnDetectBigUrlFileListener.onDetectNewDownloadFile(url, fileName, saveDir, fileSize);
                }
            });
        }

        public static void onDetectUrlFileExist(final String url, final OnDetectBigUrlFileListener nnDetectBigUrlFileListener) {
            if (nnDetectBigUrlFileListener == null) {
                return;
            }
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    if (nnDetectBigUrlFileListener == null) {
                        return;
                    }
                    nnDetectBigUrlFileListener.onDetectUrlFileExist(url);
                }
            });
        }

        public static void onDetectUrlFileFailed(final String url, final DetectBigUrlFileFailReason failReason, final OnDetectBigUrlFileListener nnDetectBigUrlFileListener) {
            if (nnDetectBigUrlFileListener == null) {
                return;
            }
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    if (nnDetectBigUrlFileListener == null) {
                        return;
                    }
                    nnDetectBigUrlFileListener.onDetectUrlFileFailed(url, failReason);
                }
            });
        }
    }
}

