/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader.file_rename;

import java.util.concurrent.ExecutorService;
import org.wlf.filedownloader.DownloadFileInfo;
import org.wlf.filedownloader.base.Log;
import org.wlf.filedownloader.file_download.OnStopFileDownloadTaskListener;
import org.wlf.filedownloader.file_download.base.Pauseable;
import org.wlf.filedownloader.file_rename.DownloadFileRenamer;
import org.wlf.filedownloader.file_rename.RenameDownloadFileTask;
import org.wlf.filedownloader.listener.OnRenameDownloadFileListener;

public class DownloadRenameManager {
    private static final String TAG = DownloadRenameManager.class.getSimpleName();
    private ExecutorService mTaskEngine;
    private DownloadFileRenamer mDownloadFileRenamer;
    private Pauseable mDownloadTaskPauseable;

    public DownloadRenameManager(ExecutorService taskEngine, DownloadFileRenamer downloadFileRenamer, Pauseable downloadTaskPauseable) {
        this.mTaskEngine = taskEngine;
        this.mDownloadFileRenamer = downloadFileRenamer;
        this.mDownloadTaskPauseable = downloadTaskPauseable;
    }

    private void addAndRunTask(Runnable task) {
        this.mTaskEngine.execute(task);
    }

    private DownloadFileInfo getDownloadFile(String url) {
        return this.mDownloadFileRenamer.getDownloadFile(url);
    }

    private void renameInternal(String url, String newFileName, boolean includedSuffix, OnRenameDownloadFileListener onRenameDownloadFileListener) {
        RenameDownloadFileTask task = new RenameDownloadFileTask(url, newFileName, includedSuffix, this.mDownloadFileRenamer);
        task.setOnRenameDownloadFileListener(onRenameDownloadFileListener);
        this.addAndRunTask(task);
    }

    public void rename(String url, final String newFileName, final boolean includedSuffix, final OnRenameDownloadFileListener onRenameDownloadFileListener) {
        final String finalUrl = url;
        if (!this.mDownloadTaskPauseable.isDownloading(url)) {
            Log.d(TAG, TAG + ".rename \u4e0b\u8f7d\u4efb\u52a1\u5df2\u7ecf\u6682\u505c\uff0c\u53ef\u4ee5\u76f4\u63a5\u91cd\u547d\u540d\uff0curl:" + url);
            this.renameInternal(url, newFileName, includedSuffix, onRenameDownloadFileListener);
        } else {
            Log.d(TAG, TAG + ".rename \u9700\u8981\u5148\u6682\u505c\u4e0b\u8f7d\u4efb\u52a1\u540e\u91cd\u547d\u540d,url:" + url);
            this.mDownloadTaskPauseable.pause(url, new OnStopFileDownloadTaskListener(){

                @Override
                public void onStopFileDownloadTaskSucceed(String url) {
                    Log.d(TAG, TAG + ".rename \u6682\u505c\u4e0b\u8f7d\u4efb\u52a1\u6210\u529f\uff0c\u5f00\u59cb\u91cd\u547d\u540d\uff0curl:" + finalUrl);
                    DownloadRenameManager.this.renameInternal(finalUrl, newFileName, includedSuffix, onRenameDownloadFileListener);
                }

                @Override
                public void onStopFileDownloadTaskFailed(String url, OnStopFileDownloadTaskListener.StopDownloadFileTaskFailReason failReason) {
                    if (failReason != null && OnStopFileDownloadTaskListener.StopDownloadFileTaskFailReason.TYPE_TASK_HAS_BEEN_STOPPED.equals(failReason.getType())) {
                        DownloadRenameManager.this.renameInternal(finalUrl, newFileName, includedSuffix, onRenameDownloadFileListener);
                        return;
                    }
                    Log.d(TAG, TAG + ".rename \u6682\u505c\u4e0b\u8f7d\u4efb\u52a1\u5931\u8d25\uff0c\u65e0\u6cd5\u91cd\u547d\u540d\uff0curl:" + finalUrl);
                    DownloadRenameManager.this.notifyRenameDownloadFileFailed(DownloadRenameManager.this.getDownloadFile(finalUrl), new OnRenameDownloadFileListener.OnRenameDownloadFileFailReason(finalUrl, failReason), onRenameDownloadFileListener);
                }
            });
        }
    }

    private void notifyRenameDownloadFileFailed(DownloadFileInfo downloadFileInfo, OnRenameDownloadFileListener.RenameDownloadFileFailReason failReason, OnRenameDownloadFileListener onRenameDownloadFileListener) {
        OnRenameDownloadFileListener.MainThreadHelper.onRenameDownloadFileFailed(downloadFileInfo, failReason, onRenameDownloadFileListener);
    }
}

