/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader.file_move;

import java.io.File;
import org.wlf.filedownloader.DownloadFileInfo;
import org.wlf.filedownloader.base.Log;
import org.wlf.filedownloader.file_move.DownloadFileMover;
import org.wlf.filedownloader.listener.OnMoveDownloadFileListener;
import org.wlf.filedownloader.util.DownloadFileUtil;
import org.wlf.filedownloader.util.FileUtil;

class MoveDownloadFileTask
implements Runnable {
    private static final String TAG = MoveDownloadFileTask.class.getSimpleName();
    private String mUrl;
    private String mNewDirPath;
    private DownloadFileMover mDownloadFileMover;
    private boolean mIsSyncCallback = false;
    private OnMoveDownloadFileListener mOnMoveDownloadFileListener;

    public MoveDownloadFileTask(String url, String newDirPath, DownloadFileMover downloadFileMover) {
        this.mUrl = url;
        this.mNewDirPath = newDirPath;
        this.mDownloadFileMover = downloadFileMover;
    }

    public void setOnMoveDownloadFileListener(OnMoveDownloadFileListener onMoveDownloadFileListener) {
        this.mOnMoveDownloadFileListener = onMoveDownloadFileListener;
    }

    public void enableSyncCallback() {
        this.mIsSyncCallback = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        OnMoveDownloadFileListener.OnMoveDownloadFileFailReason failReason;
        DownloadFileInfo downloadFileInfo;
        block32: {
            block41: {
                block33: {
                    boolean moveResult;
                    String oldDirPath;
                    File newFile;
                    File oldFile;
                    block30: {
                        block40: {
                            block31: {
                                block28: {
                                    block39: {
                                        block29: {
                                            block26: {
                                                block38: {
                                                    block27: {
                                                        block24: {
                                                            block37: {
                                                                block25: {
                                                                    block22: {
                                                                        block36: {
                                                                            block23: {
                                                                                downloadFileInfo = null;
                                                                                failReason = null;
                                                                                downloadFileInfo = this.mDownloadFileMover.getDownloadFile(this.mUrl);
                                                                                if (DownloadFileUtil.isLegal(downloadFileInfo)) break block22;
                                                                                failReason = new OnMoveDownloadFileListener.OnMoveDownloadFileFailReason(this.mUrl, "the DownloadFile is empty !", OnMoveDownloadFileListener.OnMoveDownloadFileFailReason.TYPE_NULL_POINTER);
                                                                                if (failReason != null) break block23;
                                                                                this.notifySuccess(downloadFileInfo);
                                                                                Log.d(TAG, TAG + ".run \u79fb\u52a8\u6210\u529f\uff0curl\uff1a" + this.mUrl);
                                                                                break block36;
                                                                            }
                                                                            this.notifyFailed(downloadFileInfo, failReason);
                                                                            Log.d(TAG, TAG + ".run \u79fb\u52a8\u5931\u8d25\uff0curl\uff1a" + this.mUrl + ",failReason:" + failReason.getType());
                                                                        }
                                                                        Log.d(TAG, TAG + ".run \u6587\u4ef6\u79fb\u52a8\u4efb\u52a1\u3010\u5df2\u7ed3\u675f\u3011\uff0c\u662f\u5426\u6709\u5f02\u5e38\uff1a" + (failReason == null) + "\uff0curl\uff1a" + this.mUrl);
                                                                        return;
                                                                    }
                                                                    this.notifyPrepared(downloadFileInfo);
                                                                    if (DownloadFileUtil.canMove(downloadFileInfo)) break block24;
                                                                    failReason = new OnMoveDownloadFileListener.OnMoveDownloadFileFailReason(this.mUrl, "the download file status error !", OnMoveDownloadFileListener.OnMoveDownloadFileFailReason.TYPE_FILE_STATUS_ERROR);
                                                                    if (failReason != null) break block25;
                                                                    this.notifySuccess(downloadFileInfo);
                                                                    Log.d(TAG, TAG + ".run \u79fb\u52a8\u6210\u529f\uff0curl\uff1a" + this.mUrl);
                                                                    break block37;
                                                                }
                                                                this.notifyFailed(downloadFileInfo, failReason);
                                                                Log.d(TAG, TAG + ".run \u79fb\u52a8\u5931\u8d25\uff0curl\uff1a" + this.mUrl + ",failReason:" + failReason.getType());
                                                            }
                                                            Log.d(TAG, TAG + ".run \u6587\u4ef6\u79fb\u52a8\u4efb\u52a1\u3010\u5df2\u7ed3\u675f\u3011\uff0c\u662f\u5426\u6709\u5f02\u5e38\uff1a" + (failReason == null) + "\uff0curl\uff1a" + this.mUrl);
                                                            return;
                                                        }
                                                        oldFile = null;
                                                        newFile = null;
                                                        if (DownloadFileUtil.isCompleted(downloadFileInfo)) {
                                                            oldFile = new File(downloadFileInfo.getFileDir(), downloadFileInfo.getFileName());
                                                            newFile = new File(this.mNewDirPath, downloadFileInfo.getFileName());
                                                        } else {
                                                            oldFile = new File(downloadFileInfo.getFileDir(), downloadFileInfo.getTempFileName());
                                                            newFile = new File(this.mNewDirPath, downloadFileInfo.getTempFileName());
                                                        }
                                                        if (oldFile != null && oldFile.exists()) break block26;
                                                        failReason = new OnMoveDownloadFileListener.OnMoveDownloadFileFailReason(this.mUrl, "the original file does not exist !", OnMoveDownloadFileListener.OnMoveDownloadFileFailReason.TYPE_ORIGINAL_FILE_NOT_EXIST);
                                                        if (failReason != null) break block27;
                                                        this.notifySuccess(downloadFileInfo);
                                                        Log.d(TAG, TAG + ".run \u79fb\u52a8\u6210\u529f\uff0curl\uff1a" + this.mUrl);
                                                        break block38;
                                                    }
                                                    this.notifyFailed(downloadFileInfo, failReason);
                                                    Log.d(TAG, TAG + ".run \u79fb\u52a8\u5931\u8d25\uff0curl\uff1a" + this.mUrl + ",failReason:" + failReason.getType());
                                                }
                                                Log.d(TAG, TAG + ".run \u6587\u4ef6\u79fb\u52a8\u4efb\u52a1\u3010\u5df2\u7ed3\u675f\u3011\uff0c\u662f\u5426\u6709\u5f02\u5e38\uff1a" + (failReason == null) + "\uff0curl\uff1a" + this.mUrl);
                                                return;
                                            }
                                            if (newFile == null || !newFile.exists()) break block28;
                                            failReason = new OnMoveDownloadFileListener.OnMoveDownloadFileFailReason(this.mUrl, "the target file exist !", OnMoveDownloadFileListener.OnMoveDownloadFileFailReason.TYPE_TARGET_FILE_EXIST);
                                            if (failReason != null) break block29;
                                            this.notifySuccess(downloadFileInfo);
                                            Log.d(TAG, TAG + ".run \u79fb\u52a8\u6210\u529f\uff0curl\uff1a" + this.mUrl);
                                            break block39;
                                        }
                                        this.notifyFailed(downloadFileInfo, failReason);
                                        Log.d(TAG, TAG + ".run \u79fb\u52a8\u5931\u8d25\uff0curl\uff1a" + this.mUrl + ",failReason:" + failReason.getType());
                                    }
                                    Log.d(TAG, TAG + ".run \u6587\u4ef6\u79fb\u52a8\u4efb\u52a1\u3010\u5df2\u7ed3\u675f\u3011\uff0c\u662f\u5426\u6709\u5f02\u5e38\uff1a" + (failReason == null) + "\uff0curl\uff1a" + this.mUrl);
                                    return;
                                }
                                if (newFile != null && newFile.getParentFile() != null && !newFile.getParentFile().exists()) {
                                    FileUtil.createFileParentDir(newFile.getAbsolutePath());
                                }
                                oldDirPath = downloadFileInfo.getFileDir();
                                moveResult = false;
                                try {
                                    this.mDownloadFileMover.moveDownloadFile(downloadFileInfo.getUrl(), this.mNewDirPath);
                                    moveResult = true;
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                if (moveResult) break block30;
                                failReason = new OnMoveDownloadFileListener.OnMoveDownloadFileFailReason(this.mUrl, "update record error !", OnMoveDownloadFileListener.OnMoveDownloadFileFailReason.TYPE_UPDATE_RECORD_ERROR);
                                if (failReason != null) break block31;
                                this.notifySuccess(downloadFileInfo);
                                Log.d(TAG, TAG + ".run \u79fb\u52a8\u6210\u529f\uff0curl\uff1a" + this.mUrl);
                                break block40;
                            }
                            this.notifyFailed(downloadFileInfo, failReason);
                            Log.d(TAG, TAG + ".run \u79fb\u52a8\u5931\u8d25\uff0curl\uff1a" + this.mUrl + ",failReason:" + failReason.getType());
                        }
                        Log.d(TAG, TAG + ".run \u6587\u4ef6\u79fb\u52a8\u4efb\u52a1\u3010\u5df2\u7ed3\u675f\u3011\uff0c\u662f\u5426\u6709\u5f02\u5e38\uff1a" + (failReason == null) + "\uff0curl\uff1a" + this.mUrl);
                        return;
                    }
                    try {
                        moveResult = oldFile.renameTo(newFile);
                        if (moveResult) break block32;
                        try {
                            this.mDownloadFileMover.moveDownloadFile(downloadFileInfo.getUrl(), oldDirPath);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            try {
                                this.mDownloadFileMover.moveDownloadFile(downloadFileInfo.getUrl(), oldDirPath);
                            }
                            catch (Exception e1) {
                                e1.printStackTrace();
                            }
                        }
                        failReason = new OnMoveDownloadFileListener.OnMoveDownloadFileFailReason(this.mUrl, "update record error !", OnMoveDownloadFileListener.OnMoveDownloadFileFailReason.TYPE_UPDATE_RECORD_ERROR);
                        if (failReason != null) break block33;
                        this.notifySuccess(downloadFileInfo);
                    }
                    catch (Exception e) {
                        block42: {
                            block34: {
                                try {
                                    e.printStackTrace();
                                    failReason = new OnMoveDownloadFileListener.OnMoveDownloadFileFailReason(this.mUrl, e);
                                    if (failReason != null) break block34;
                                    this.notifySuccess(downloadFileInfo);
                                }
                                catch (Throwable throwable) {
                                    if (failReason == null) {
                                        this.notifySuccess(downloadFileInfo);
                                        Log.d(TAG, TAG + ".run \u79fb\u52a8\u6210\u529f\uff0curl\uff1a" + this.mUrl);
                                    } else {
                                        this.notifyFailed(downloadFileInfo, failReason);
                                        Log.d(TAG, TAG + ".run \u79fb\u52a8\u5931\u8d25\uff0curl\uff1a" + this.mUrl + ",failReason:" + failReason.getType());
                                    }
                                    Log.d(TAG, TAG + ".run \u6587\u4ef6\u79fb\u52a8\u4efb\u52a1\u3010\u5df2\u7ed3\u675f\u3011\uff0c\u662f\u5426\u6709\u5f02\u5e38\uff1a" + (failReason == null) + "\uff0curl\uff1a" + this.mUrl);
                                    throw throwable;
                                }
                                Log.d(TAG, TAG + ".run \u79fb\u52a8\u6210\u529f\uff0curl\uff1a" + this.mUrl);
                                break block42;
                            }
                            this.notifyFailed(downloadFileInfo, failReason);
                            Log.d(TAG, TAG + ".run \u79fb\u52a8\u5931\u8d25\uff0curl\uff1a" + this.mUrl + ",failReason:" + failReason.getType());
                        }
                        Log.d(TAG, TAG + ".run \u6587\u4ef6\u79fb\u52a8\u4efb\u52a1\u3010\u5df2\u7ed3\u675f\u3011\uff0c\u662f\u5426\u6709\u5f02\u5e38\uff1a" + (failReason == null) + "\uff0curl\uff1a" + this.mUrl);
                    }
                    Log.d(TAG, TAG + ".run \u79fb\u52a8\u6210\u529f\uff0curl\uff1a" + this.mUrl);
                    break block41;
                }
                this.notifyFailed(downloadFileInfo, failReason);
                Log.d(TAG, TAG + ".run \u79fb\u52a8\u5931\u8d25\uff0curl\uff1a" + this.mUrl + ",failReason:" + failReason.getType());
            }
            Log.d(TAG, TAG + ".run \u6587\u4ef6\u79fb\u52a8\u4efb\u52a1\u3010\u5df2\u7ed3\u675f\u3011\uff0c\u662f\u5426\u6709\u5f02\u5e38\uff1a" + (failReason == null) + "\uff0curl\uff1a" + this.mUrl);
            return;
        }
        if (failReason == null) {
            this.notifySuccess(downloadFileInfo);
            Log.d(TAG, TAG + ".run \u79fb\u52a8\u6210\u529f\uff0curl\uff1a" + this.mUrl);
        } else {
            this.notifyFailed(downloadFileInfo, failReason);
            Log.d(TAG, TAG + ".run \u79fb\u52a8\u5931\u8d25\uff0curl\uff1a" + this.mUrl + ",failReason:" + failReason.getType());
        }
        Log.d(TAG, TAG + ".run \u6587\u4ef6\u79fb\u52a8\u4efb\u52a1\u3010\u5df2\u7ed3\u675f\u3011\uff0c\u662f\u5426\u6709\u5f02\u5e38\uff1a" + (failReason == null) + "\uff0curl\uff1a" + this.mUrl);
    }

    private void notifyPrepared(DownloadFileInfo downloadFileInfo) {
        if (this.mOnMoveDownloadFileListener == null) {
            return;
        }
        if (this.mIsSyncCallback) {
            this.mOnMoveDownloadFileListener.onMoveDownloadFilePrepared(downloadFileInfo);
        } else {
            OnMoveDownloadFileListener.MainThreadHelper.onMoveDownloadFilePrepared(downloadFileInfo, this.mOnMoveDownloadFileListener);
        }
    }

    private void notifySuccess(DownloadFileInfo downloadFileInfo) {
        if (this.mOnMoveDownloadFileListener == null) {
            return;
        }
        if (this.mIsSyncCallback) {
            this.mOnMoveDownloadFileListener.onMoveDownloadFileSuccess(downloadFileInfo);
        } else {
            OnMoveDownloadFileListener.MainThreadHelper.onMoveDownloadFileSuccess(downloadFileInfo, this.mOnMoveDownloadFileListener);
        }
    }

    private void notifyFailed(DownloadFileInfo downloadFileInfo, OnMoveDownloadFileListener.MoveDownloadFileFailReason failReason) {
        if (this.mOnMoveDownloadFileListener == null) {
            return;
        }
        if (this.mIsSyncCallback) {
            this.mOnMoveDownloadFileListener.onMoveDownloadFileFailed(downloadFileInfo, failReason);
        } else {
            OnMoveDownloadFileListener.MainThreadHelper.onMoveDownloadFileFailed(downloadFileInfo, failReason, this.mOnMoveDownloadFileListener);
        }
    }
}

