/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader.file_move;

import java.util.List;
import java.util.concurrent.ExecutorService;
import org.wlf.filedownloader.DownloadFileInfo;
import org.wlf.filedownloader.base.Control;
import org.wlf.filedownloader.base.Log;
import org.wlf.filedownloader.file_download.OnStopFileDownloadTaskListener;
import org.wlf.filedownloader.file_download.base.Pauseable;
import org.wlf.filedownloader.file_move.DownloadFileMover;
import org.wlf.filedownloader.file_move.MoveDownloadFileTask;
import org.wlf.filedownloader.file_move.MoveDownloadFilesTask;
import org.wlf.filedownloader.listener.OnMoveDownloadFileListener;
import org.wlf.filedownloader.listener.OnMoveDownloadFilesListener;

public class DownloadMoveManager {
    private static final String TAG = DownloadMoveManager.class.getSimpleName();
    private ExecutorService mTaskEngine;
    private DownloadFileMover mDownloadFileMover;
    private Pauseable mDownloadTaskPauseable;
    private MoveControl mMoveControl;

    public DownloadMoveManager(ExecutorService taskEngine, DownloadFileMover downloadFileMover, Pauseable downloadTaskPauseable) {
        this.mTaskEngine = taskEngine;
        this.mDownloadFileMover = downloadFileMover;
        this.mDownloadTaskPauseable = downloadTaskPauseable;
    }

    private void addAndRunTask(Runnable task) {
        this.mTaskEngine.execute(task);
    }

    private DownloadFileInfo getDownloadFile(String url) {
        return this.mDownloadFileMover.getDownloadFile(url);
    }

    private void singleMoveInternal(String url, String newDirPath, OnMoveDownloadFileListener onMoveDownloadFileListener) {
        MoveDownloadFileTask moveDownloadFileTask = new MoveDownloadFileTask(url, newDirPath, this.mDownloadFileMover);
        moveDownloadFileTask.setOnMoveDownloadFileListener(onMoveDownloadFileListener);
        this.addAndRunTask(moveDownloadFileTask);
    }

    public void move(String url, final String newDirPath, final OnMoveDownloadFileListener onMoveDownloadFileListener) {
        final String finalUrl = url;
        if (!this.mDownloadTaskPauseable.isDownloading(url)) {
            Log.d(TAG, TAG + ".move \u4e0b\u8f7d\u4efb\u52a1\u5df2\u7ecf\u6682\u505c\uff0c\u53ef\u4ee5\u76f4\u63a5\u79fb\u52a8\uff0curl:" + url);
            this.singleMoveInternal(url, newDirPath, onMoveDownloadFileListener);
        } else {
            Log.d(TAG, TAG + ".move \u9700\u8981\u5148\u6682\u505c\u4e0b\u8f7d\u4efb\u52a1\u540e\u79fb\u52a8\uff0curl:" + url);
            this.mDownloadTaskPauseable.pause(url, new OnStopFileDownloadTaskListener(){

                @Override
                public void onStopFileDownloadTaskSucceed(String url) {
                    Log.d(TAG, TAG + ".move \u6682\u505c\u4e0b\u8f7d\u4efb\u52a1\u6210\u529f\uff0c\u5f00\u59cb\u79fb\u52a8\uff0curl:" + finalUrl);
                    DownloadMoveManager.this.singleMoveInternal(finalUrl, newDirPath, onMoveDownloadFileListener);
                }

                @Override
                public void onStopFileDownloadTaskFailed(String url, OnStopFileDownloadTaskListener.StopDownloadFileTaskFailReason failReason) {
                    if (failReason != null && OnStopFileDownloadTaskListener.StopDownloadFileTaskFailReason.TYPE_TASK_HAS_BEEN_STOPPED.equals(failReason.getType())) {
                        DownloadMoveManager.this.singleMoveInternal(finalUrl, newDirPath, onMoveDownloadFileListener);
                        return;
                    }
                    Log.d(TAG, TAG + ".move \u6682\u505c\u4e0b\u8f7d\u4efb\u52a1\u5931\u8d25\uff0c\u65e0\u6cd5\u79fb\u52a8\uff0curl:" + finalUrl);
                    DownloadMoveManager.this.notifyMoveDownloadFileFailed(DownloadMoveManager.this.getDownloadFile(finalUrl), new OnMoveDownloadFileListener.OnMoveDownloadFileFailReason(finalUrl, failReason), onMoveDownloadFileListener);
                }
            });
        }
    }

    public Control move(List<String> urls, String newDirPath, OnMoveDownloadFilesListener onMoveDownloadFilesListener) {
        if (this.mMoveControl != null && !this.mMoveControl.isStopped()) {
            return this.mMoveControl;
        }
        MoveDownloadFilesTask moveDownloadFilesTask = new MoveDownloadFilesTask(urls, newDirPath, this.mTaskEngine, this.mDownloadFileMover, this.mDownloadTaskPauseable);
        moveDownloadFilesTask.setOnMoveDownloadFilesListener(onMoveDownloadFilesListener);
        this.addAndRunTask(moveDownloadFilesTask);
        this.mMoveControl = new MoveControl(moveDownloadFilesTask);
        return this.mMoveControl;
    }

    private void notifyMoveDownloadFileFailed(DownloadFileInfo downloadFileInfo, OnMoveDownloadFileListener.MoveDownloadFileFailReason failReason, OnMoveDownloadFileListener onMoveDownloadFileListener) {
        OnMoveDownloadFileListener.MainThreadHelper.onMoveDownloadFileFailed(downloadFileInfo, failReason, onMoveDownloadFileListener);
    }

    private static class MoveControl
    implements Control {
        private MoveDownloadFilesTask mMoveDownloadFilesTask;

        private MoveControl(MoveDownloadFilesTask moveDownloadFilesTask) {
            this.mMoveDownloadFilesTask = moveDownloadFilesTask;
        }

        @Override
        public void stop() {
            if (this.mMoveDownloadFilesTask != null) {
                this.mMoveDownloadFilesTask.stop();
            }
        }

        @Override
        public boolean isStopped() {
            if (this.mMoveDownloadFilesTask == null) {
                return true;
            }
            return this.mMoveDownloadFilesTask.isStopped();
        }
    }
}

