/*
 * Decompiled with CFR 0.152.
 */
package org.wlf.filedownloader.file_download.base;

import java.net.ConnectException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import org.wlf.filedownloader.base.UrlFailReason;

public class HttpFailReason
extends UrlFailReason {
    public static final String TYPE_NETWORK_DENIED = HttpFailReason.class.getName() + "_TYPE_NETWORK_DENIED";
    public static final String TYPE_NETWORK_TIMEOUT = HttpFailReason.class.getName() + "_TYPE_NETWORK_TIMEOUT";

    public HttpFailReason(String url, String detailMessage, String type) {
        super(url, detailMessage, type);
    }

    public HttpFailReason(String url, Throwable throwable) {
        super(url, throwable);
    }

    @Override
    protected void onInitTypeWithOriginalThrowable(Throwable throwable) {
        super.onInitTypeWithOriginalThrowable(throwable);
        if (throwable == null) {
            return;
        }
        if (throwable instanceof SocketTimeoutException) {
            this.setType(TYPE_NETWORK_TIMEOUT);
        } else if (throwable instanceof ConnectException || throwable instanceof UnknownHostException) {
            this.setType(TYPE_NETWORK_DENIED);
        } else if (throwable instanceof SocketException) {
            this.setType(TYPE_NETWORK_DENIED);
        }
    }
}

